/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropPlayerHasXPLevel
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropPlayerHasXPLevel(JsonObject obj) {
        super(obj, "require_XP_Level");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int amount = JsonUtil.getOrDefault(obj, "value", 0);
            if (JsonUtil.getOrDefault(obj, "required", true)) {
                this.operation = new BiggerOperation(amount);
                this.setJEIInfo("Player ExperienceLevels should be above " + amount + " XP");
            } else {
                this.operation = new SmallerOperation(amount);
                this.setJEIInfo("Players ExperienceLevels should be below " + amount + " XP");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(player.field_71068_ca);
    }

    public static class PlayerHasXPLevelFactory
    extends BaseResourceFactory {
        public PlayerHasXPLevelFactory() {
            super("require_XP_Level", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
            this.addIncompat("require_XP", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerHasXPLevel(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("required", true, "If the player should require that amount or stay below it"));
            choice.addElement(0, new IntElement("value", 0, "How many Experience levels should be checked for"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to Check for Experience levels");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("required", Boolean.valueOf(true));
            obj.addProperty("value", (Number)10);
        }
    }
}

