/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropPlayerHasXP
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropPlayerHasXP(JsonObject obj) {
        super(obj, "require_XP");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int amount = JsonUtil.getOrDefault(obj, "value", 0);
            if (JsonUtil.getOrDefault(obj, "required", true)) {
                this.operation = new BiggerOperation(amount);
                this.setJEIInfo("Player Experience should be above " + amount + " XP");
            } else {
                this.operation = new SmallerOperation(amount);
                this.setJEIInfo("Players Experience should be below " + amount + " XP");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(player.field_71067_cb);
    }

    public static class PlayerHasXPFactory
    extends BaseResourceFactory {
        public PlayerHasXPFactory() {
            super("require_XP", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
            this.addIncompat("require_XP_Level", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerHasXP(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("required", true, "If the Player requires that amount of XP or if it should be below the amount"));
            choice.addElement(0, new IntElement("value", 0, "how much XP should be checked for"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to check if the Player has a Certain amount of XP");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("required", Boolean.valueOf(true));
            obj.addProperty("value", (Number)100);
        }
    }
}

