/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropPlayerHasHunger
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropPlayerHasHunger(JsonObject obj) {
        super(obj, "require_hunger");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = JsonUtil.getOrDefault(obj, "value", 0);
            if (JsonUtil.getOrDefault(obj, "bigger", true)) {
                this.operation = new BiggerOperation(value);
                this.setJEIInfo("Players Hunger is bigger then " + value);
            } else {
                this.operation = new SmallerOperation(value);
                this.setJEIInfo("Players Hunger is smaller then " + value);
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(player.func_71024_bL().func_75116_a());
    }

    public static class HasHungerFactory
    extends BaseResourceFactory {
        public HasHungerFactory() {
            super("require_hunger", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerHasHunger(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("bigger", Boolean.valueOf(true));
            obj.addProperty("value", (Number)10);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("bigger", true, "If the Hunger should be bigger then the given value"));
            choice.addElement(0, new IntElement("value", 0, "how much Hunger should be required or not"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to check for the Players Hunger");
            return map;
        }
    }
}

