/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropPlayerBurnsFactory
extends BaseResourceProperty
implements IResourceCondition {
    boolean required;

    public PropPlayerBurnsFactory(JsonObject obj) {
        super(obj, "is_burning");
        this.addSelfIncompat();
        this.required = JsonUtil.getOrDefault(obj, "required", true);
        if (this.required) {
            this.setJEIInfo("Player has to burn");
        } else {
            this.setJEIInfo("Player isn't allowed to burn");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return player.func_70027_ad() == this.required;
    }

    public static class PlayerIsBurningFactory
    extends BaseResourceFactory {
        public PlayerIsBurningFactory() {
            super("is_burning", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerBurnsFactory(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("required", Boolean.valueOf(true));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check if the Player is burning");
            map.addElement(new BooleanElement("required", true, "if the player has to burn or not"));
            return map;
        }
    }
}

