/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropHasItemList
extends BaseResourceProperty
implements IResourceCondition {
    List<ItemStack> toCompare = new ArrayList<ItemStack>();
    boolean offHand;

    public PropHasItemList(JsonObject obj) {
        super(obj, "require_item_list");
        this.addIncompats("require_item", "require_tool", "require_empty_Hand");
        this.offHand = JsonUtil.getOrDefault(obj, "offHand", false);
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                ItemStack stack = JsonUtil.createCompareStack(t);
                if (stack == null) {
                    FMLLog.getLogger().info("Object [" + t + "] creates a Null Stack!");
                    return;
                }
                PropHasItemList.this.toCompare.add(stack);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        for (ItemStack stack : this.toCompare) {
            collector.addRequiredItem(stack);
        }
        collector.addInfo("Require Item List (" + (this.offHand ? "OffHand" : "MainHand") + ")");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        ItemStack playerStack = player.func_184586_b(this.offHand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (LootUtil.isStackEmpty(playerStack)) {
            return false;
        }
        for (ItemStack stack : this.toCompare) {
            if (stack.func_77973_b() != playerStack.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != playerStack.func_77960_j() || LootUtil.getStackSize(stack) > LootUtil.getStackSize(playerStack)) continue;
            return true;
        }
        return false;
    }

    public static class HasItemListFactory
    extends BaseResourceFactory {
        public HasItemListFactory() {
            super("require_item_list", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
            this.addIncompats(CompatState.INCOMPATIBLE, "require_item", "require_tool", "require_empty_Hand");
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasItemList(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement item = new MapElement("");
            item.addElement(new TextElement("name", "").setDescription("Item that should be checkt for"));
            item.addElement(new IntElement("amount", 1, "The Stacksize that should be checkt for"));
            item.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata that should be compared with, (32767 == Ignore Meta)"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("items", item).setDescription("The Items that should be compared with"));
            map.setDescription("Allows to check if a player has 1 of the items in a list");
            map.addElement(new BooleanElement("offHand", false, "If the Item should be present in the Offhand or mainHand"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            obj.add("items", (JsonElement)array);
            JsonObject object = new JsonObject();
            array.add((JsonElement)object);
            object.addProperty("name", "minecraft:stick");
            object.addProperty("amount", (Number)1);
            object.addProperty("meta", (Number)Short.MAX_VALUE);
        }
    }
}

