/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.props;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.loot.props.PropSendFlagToLoot;

public class PropSendNumberToLoot
extends BaseResourceProperty
implements IResourceEffect {
    String numberID;
    int value;

    public PropSendNumberToLoot(JsonObject obj) {
        super(obj, "sendNumberToLoot");
        this.numberID = obj.get("NumberID").getAsString();
        this.value = JsonUtil.getOrDefault(obj, "value", 0);
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        container.setInteger(this.numberID, this.value);
        return true;
    }

    public static class SendNumberToLootFactory
    extends BaseResourceFactory {
        public SendNumberToLootFactory() {
            super("sendNumberToLoot", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSendFlagToLoot(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("NumberID", "ExampleID");
            obj.addProperty("value", (Number)12502);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("NumberID", "").setDescription("The ID that should be send to the LootGenerator"));
            map.addElement(new BooleanElement("value", true, "What the Value should be thats being send"));
            map.setDescription("Allows to send a Number to the Loot Generator to be processed");
            return map;
        }
    }
}

