/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.mixed;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;

public class PropRandomLoot
extends BaseActiveLootProperty {
    double chance;
    ILootProperty prop;

    public PropRandomLoot(JsonObject obj) {
        super("set_random_loot");
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        this.prop = this.createLoot(obj.getAsJsonObject("loot"));
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        if (this.chance >= rand.nextDouble() * 100.0) {
            if (this.prop.isActiveProperty()) {
                return this.prop.applyActiveEffect(stack, customData);
            }
            this.prop.applyPassiveEffect(stack);
        }
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(stack.func_77946_l());
        if (this.prop.hasMultiResults()) {
            list.addAll(this.prop.applyMultiInfoEffect(stack));
        } else {
            list.add(this.prop.applyInfoEffect(stack));
        }
        return list;
    }

    public static class RandomLootFactory
    extends BaseLootFactory {
        public RandomLootFactory() {
            super("set_random_loot", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropRandomLoot(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new MapElement("loot").setDescription("The LootProperty that should be applied"));
            map.addElement(new DoubleElement("chance", 100.0).setDescription("How likely it is that the LootProperty is applied"));
            map.setDescription("Allows to add a Chance obj to a LootProperty");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject data = new JsonObject();
            data.addProperty("type", "lootID");
            obj.add("loot", (JsonElement)data);
            obj.addProperty("chance", (Number)95.0);
        }
    }
}

