/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;

public class PropAddRandomEnchantment
extends BaseActiveLootProperty {
    List<EnchantmentData> data = new ArrayList<EnchantmentData>();

    public PropAddRandomEnchantment(JsonObject obj) {
        super("add_random_enchantment");
        JsonUtil.convertToObject(obj.get("enchantments"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(t.get("name").getAsString()));
                if (ench == null) {
                    return;
                }
                PropAddRandomEnchantment.this.data.add(new EnchantmentData(ench, t.get("level").getAsInt()));
            }
        });
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        EnchantmentData entry = this.data.get(rand.nextInt(this.data.size()));
        stack.func_77966_a(entry.field_76302_b, entry.field_76303_c);
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (EnchantmentData ench : this.data) {
            ItemStack copy = stack.func_77946_l();
            copy.func_77966_a(ench.field_76302_b, ench.field_76303_c);
            stackList.add(copy);
        }
        return stackList;
    }

    public static class AddRandomEnchantmentFactory
    extends BaseLootFactory {
        public AddRandomEnchantmentFactory() {
            super("add_random_enchantment", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddRandomEnchantment(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new TextElement("name", "").setDescription("Enchantment registry name of the Enchantment you want to use"));
            map.addElement(new IntElement("level", 0).setDescription("The Level of the Enchantment"));
            MapElement base = new MapElement("");
            map.addElement(new OptionalArrayElement("enchantments", map));
            return base;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:unbreaking");
            object.addProperty("level", (Number)2);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("enchantments", (JsonElement)array);
        }
    }
}

