/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.operation;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.impl.BaseMathOperation;
import scavenge.api.math.impl.BaseOperationFactory;
import scavenge.api.utils.CompatState;

public class BiggerEqualsOperation
extends BaseMathOperation {
    long check;

    public BiggerEqualsOperation(JsonObject obj) {
        this(obj.get("value").getAsLong());
        if (obj.has("modifiers")) {
            this.addMathModifiers(obj.get("modifiers"));
        }
    }

    public BiggerEqualsOperation(long value) {
        super("biggerEquals");
        this.check = value;
    }

    @Override
    public boolean matches(long value) {
        return this.getValue(value) > this.check;
    }

    public static class BiggerEqualsFactory
    extends BaseOperationFactory {
        public BiggerEqualsFactory() {
            super("biggerEquals");
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IMathOperation createObject(JsonObject obj) {
            return new BiggerEqualsOperation(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new LongElement("value", 0L).setDescription("The Value the Operation should compare with"));
            map.setDescription("Checks if the Input Value is bigger or equals the selected Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)100);
        }
    }
}

