/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.modifiers;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.impl.BaseMathModifier;
import scavenge.api.math.impl.BaseModifierFactory;

public class RemoveModifier
extends BaseMathModifier {
    long value;

    public RemoveModifier(JsonObject obj) {
        this(obj.get("value").getAsLong());
    }

    public RemoveModifier(long value) {
        super("remove");
        this.value = value;
    }

    @Override
    public long modify(long input) {
        return input + this.value;
    }

    public static class RemoveFactory
    extends BaseModifierFactory {
        public RemoveFactory() {
            super("remove");
        }

        @Override
        public IMathModifier createObject(JsonObject obj) {
            return new RemoveModifier(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new LongElement("value", 0L).setDescription("The Value that should be removed"));
            map.setDescription("Removes a Selected Value from the Input Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)100);
        }
    }
}

