/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.modifiers;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.impl.BaseMathModifier;
import scavenge.api.math.impl.BaseModifierFactory;

public class PowModifier
extends BaseMathModifier {
    long value;

    public PowModifier(JsonObject obj) {
        this(obj.get("value").getAsLong());
    }

    public PowModifier(long value) {
        super("pow");
        this.value = value;
    }

    @Override
    public long modify(long input) {
        return (long)Math.pow(input, this.value);
    }

    public static class PowFactory
    extends BaseModifierFactory {
        public PowFactory() {
            super("pow");
        }

        @Override
        public IMathModifier createObject(JsonObject obj) {
            return new PowModifier(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new LongElement("value", 0L).setDescription("The Value that should be pow with"));
            map.setDescription("Pows the Input Value with the Selected Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)2);
        }
    }
}

