/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loaders;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import scavenge.api.IScavengeFactory;
import scavenge.api.ScavengeAPI;
import scavenge.api.block.IResourceProperty;
import scavenge.api.loot.ILootProperty;
import scavenge.api.utils.CompatState;

public class IncompatLoader {
    Map<Class, CompatInfo> incompats = new HashMap<Class, CompatInfo>();

    public void loadIncompats(ScavengeAPI api) {
        CompatInfo info = new CompatInfo();
        info.addInfos(api.getLootFactories());
        if (info.hasIncompats()) {
            this.incompats.put(ILootProperty.class, info);
        }
        info = new CompatInfo();
        info.addInfos(api.getResourceFactory());
        if (info.hasIncompats()) {
            this.incompats.put(IResourceProperty.class, info);
        }
    }

    public String getIncompat(Class clz, String id) {
        CompatInfo info = this.incompats.get(clz);
        if (info == null) {
            return "None";
        }
        return info.getIncompats(id);
    }

    public static class Incompats
    implements BiConsumer<String, CompatState> {
        Map<String, CompatState> states = new HashMap<String, CompatState>();
        String id;

        public Incompats(IScavengeFactory factory) {
            this.id = factory.getID();
        }

        @Override
        public void accept(String t, CompatState u) {
            this.states.put(t, u);
        }

        public boolean hasStuff() {
            return this.states.size() > 0;
        }

        public String getIncompats() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, CompatState> entry : this.states.entrySet()) {
                if (entry.getKey().equals(this.id)) {
                    builder.append("Duplicate(" + entry.getValue().getDisplayName() + ") ");
                    continue;
                }
                builder.append(entry.getKey() + "(" + entry.getValue().getDisplayName() + ") ");
            }
            return builder.toString();
        }
    }

    public static class CompatInfo {
        Map<String, Incompats> incompats = new LinkedHashMap<String, Incompats>();

        public void addInfos(List<? extends IScavengeFactory> list) {
            for (IScavengeFactory iScavengeFactory : list) {
                this.addInfo(iScavengeFactory);
            }
        }

        public void addInfo(IScavengeFactory factory) {
            Incompats incomp = new Incompats(factory);
            factory.addIncompats(incomp);
            if (incomp.hasStuff()) {
                this.incompats.put(factory.getID(), incomp);
            }
        }

        public boolean hasIncompats() {
            return this.incompats.size() > 0;
        }

        public String getIncompats(String id) {
            Incompats incom = this.incompats.get(id);
            if (incom == null) {
                return "None";
            }
            return incom.getIncompats();
        }
    }
}

