/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.handlers;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import scavenge.api.utils.IntCounter;
import scavenge.api.world.IDelivered;
import scavenge.api.world.IGlobalHandler;

public class GlobalWorldHandler
extends WorldSavedData
implements IGlobalHandler {
    Map<String, IntCounter> counters = new LinkedHashMap<String, IntCounter>();
    Map<String, NBTTagCompound> customData = new LinkedHashMap<String, NBTTagCompound>();

    public GlobalWorldHandler(String name) {
        super(name);
    }

    @Override
    public IDelivered<IntCounter> getCounter(final String id) {
        return new IDelivered<IntCounter>(){

            @Override
            public IntCounter get() {
                IntCounter counter = GlobalWorldHandler.this.counters.get(id);
                if (counter == null) {
                    counter = new IntCounter(0);
                    GlobalWorldHandler.this.counters.put(id, counter);
                }
                return counter;
            }

            @Override
            public boolean exists() {
                return GlobalWorldHandler.this.counters.containsKey(id);
            }

            @Override
            public void onChanged() {
                GlobalWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                GlobalWorldHandler.this.counters.remove(id);
            }
        };
    }

    @Override
    public IDelivered<NBTTagCompound> getCustomData(final String id) {
        return new IDelivered<NBTTagCompound>(){

            @Override
            public NBTTagCompound get() {
                NBTTagCompound data = GlobalWorldHandler.this.customData.get(id);
                if (data == null) {
                    data = new NBTTagCompound();
                    GlobalWorldHandler.this.customData.put(id, data);
                }
                return data;
            }

            @Override
            public boolean exists() {
                return GlobalWorldHandler.this.customData.containsKey(id);
            }

            @Override
            public void onChanged() {
                GlobalWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                GlobalWorldHandler.this.customData.remove(id);
            }
        };
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagCompound nbt;
        int i;
        this.counters.clear();
        this.customData.clear();
        NBTTagList list = compound.func_150295_c("Counters", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            this.counters.put(nbt.func_74779_i("K"), new IntCounter(nbt.func_74762_e("V")));
        }
        list = compound.func_150295_c("CustomData", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            this.customData.put(nbt.func_74779_i("K"), nbt.func_74775_l("V"));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound nbt;
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, IntCounter> entry : this.counters.entrySet()) {
            nbt = new NBTTagCompound();
            nbt.func_74778_a("K", entry.getKey());
            nbt.func_74768_a("V", entry.getValue().getCurrentValue());
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Counters", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, IntCounter> entry : this.customData.entrySet()) {
            nbt = new NBTTagCompound();
            nbt.func_74778_a("K", entry.getKey());
            nbt.func_74782_a("V", (NBTBase)((NBTTagCompound)entry.getValue()).func_74737_b());
        }
        compound.func_74782_a("CustomData", (NBTBase)list);
        return compound;
    }
}

