/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.builder.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.core.builder.block.IBlockResource;
import scavenge.core.loot.ILoot;

public class BlockResource
implements IBlockResource {
    String id;
    String globalError;
    String successMessage;
    Map<Block, Set<Integer>> metaMap = new HashMap<Block, Set<Integer>>();
    List<BlockEntry> entries = new ArrayList<BlockEntry>();
    Map<String, String> messages = new HashMap<String, String>();
    List<IResourceCondition> conditions = new ArrayList<IResourceCondition>();
    List<IResourceEffect> effects = new ArrayList<IResourceEffect>();
    Map<ILoot, IResourceCondition[]> conditionalLoot = new LinkedHashMap<ILoot, IResourceCondition[]>();
    List<ILoot> dropLoot = new ArrayList<ILoot>();
    boolean shouldShow;
    int leftClick;
    int rightClick;
    boolean breaking;
    boolean placeing;

    public BlockResource(String name, List<BlockEntry> state, List<IResourceProperty> props, List<ILoot> loots, Map<ILoot, IResourceCondition[]> cLoot, Map<String, String> messageMap, int left, int right, boolean breaking, boolean placeing, boolean shouldDisplay) {
        this.id = name;
        this.addBlocks(state);
        this.addProperties(props);
        this.dropLoot.addAll(loots);
        this.conditionalLoot.putAll(cLoot);
        this.messages.putAll(messageMap);
        this.globalError = this.messages.remove("global");
        this.successMessage = this.messages.remove("success");
        this.leftClick = left;
        this.rightClick = right;
        this.breaking = breaking;
        this.placeing = placeing;
        this.shouldShow = shouldDisplay;
    }

    private void addBlocks(List<BlockEntry> states) {
        for (BlockEntry entry : states) {
            this.entries.add(entry);
            Set<Integer> set = this.metaMap.get(entry.getBlock());
            if (set == null) {
                set = new HashSet<Integer>();
                this.metaMap.put(entry.getBlock(), set);
            }
            if (set.contains(Short.MAX_VALUE)) continue;
            if (entry.isBlank()) {
                set.clear();
                set.add((Integer)Short.MAX_VALUE);
                continue;
            }
            set.add(entry.getMeta());
        }
    }

    private void addProperties(List<IResourceProperty> list) {
        for (IResourceProperty prop : list) {
            if (prop instanceof IResourceCondition) {
                this.conditions.add((IResourceCondition)prop);
            }
            if (!(prop instanceof IResourceEffect)) continue;
            this.effects.add((IResourceEffect)prop);
        }
    }

    @Override
    public boolean isLeftClick() {
        return this.leftClick > 0;
    }

    @Override
    public boolean isRightClick() {
        return this.rightClick > 0;
    }

    @Override
    public boolean isBreaking() {
        return this.breaking;
    }

    @Override
    public boolean isPlacing() {
        return this.placeing;
    }

    @Override
    public boolean isBlockingRightClick() {
        return this.rightClick == 1;
    }

    @Override
    public boolean isBlockingLeftClick() {
        return this.leftClick == 1;
    }

    @Override
    public boolean shouldDisplay() {
        return this.shouldShow;
    }

    @Override
    public List<BlockEntry> getBlockEntries() {
        return this.entries;
    }

    @Override
    public List<ILoot> getLoot() {
        ArrayList<ILoot> newList = new ArrayList<ILoot>(this.dropLoot);
        newList.addAll(this.conditionalLoot.keySet());
        return newList;
    }

    @Override
    public List<? extends IResourceProperty> getConditions() {
        return this.conditions;
    }

    @Override
    public List<? extends IResourceProperty> getEffects() {
        return this.effects;
    }

    @Override
    public boolean blockMatches(IBlockState state) {
        Set<Integer> set = this.metaMap.get(state.func_177230_c());
        if (set == null) {
            return false;
        }
        return set.contains(Short.MAX_VALUE) || set.contains(state.func_177230_c().func_176201_c(state));
    }

    @Override
    public void applyEffect(IBlockState state, World world, BlockPos pos, boolean leftClick, EnumFacing side, EntityPlayer player) {
        ArrayList<ILoot> lootToDrop = new ArrayList<ILoot>(this.dropLoot);
        for (Map.Entry<ILoot, IResourceCondition[]> entry : this.conditionalLoot.entrySet()) {
            if (!this.canDropLoot(entry.getValue(), state, player, pos, leftClick, side)) continue;
            lootToDrop.add(entry.getKey());
        }
        EffectContainer container = new EffectContainer();
        HashSet<String> data = new HashSet<String>();
        for (IResourceEffect effect : this.effects) {
            String toSend;
            if (!effect.applyEffects(state, world, pos, player, leftClick, side, this.id, container) || (toSend = this.messages.get(this.getNextID(effect.getID(), data))) == null) continue;
            player.func_146105_b((ITextComponent)new TextComponentString(toSend), true);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        NBTTagCompound nbt = container.getData();
        int maxRolls = container.getRolls();
        for (int i = 0; i < maxRolls; ++i) {
            for (ILoot loot : lootToDrop) {
                double chance;
                if (i >= loot.getMaxRools() || !((chance = container.getChance(loot.getChance())) >= world.field_73012_v.nextDouble() * 100.0)) continue;
                drops.addAll(loot.getDrops(world.field_73012_v, nbt));
            }
        }
        if (container.shouldDropItems()) {
            for (ItemStack stack : drops) {
                player.func_71019_a(stack, false);
            }
        } else {
            for (ItemStack stack : drops) {
                if (player.field_71071_by.func_70441_a(stack)) continue;
                player.func_71019_a(stack, false);
            }
        }
        if (this.successMessage != null) {
            player.func_146105_b((ITextComponent)new TextComponentString(this.successMessage), true);
        }
    }

    @Override
    public boolean matches(IBlockState state, EntityPlayer player, BlockPos pos, boolean leftclick, EnumFacing side, boolean client) {
        return this.blockMatches(state) && this.propsMatch(state, player, pos, leftclick, side, client);
    }

    protected boolean canDropLoot(IResourceCondition[] conditions, IBlockState state, EntityPlayer player, BlockPos pos, boolean leftClick, EnumFacing side) {
        for (IResourceCondition condition : conditions) {
            if (condition.canInteract(state, player.field_70170_p, pos, player, leftClick, side, this.id, false)) continue;
            return false;
        }
        return true;
    }

    protected boolean propsMatch(IBlockState state, EntityPlayer player, BlockPos pos, boolean leftClick, EnumFacing side, boolean client) {
        HashSet<String> keys = new HashSet<String>();
        for (IResourceCondition prop : this.conditions) {
            if (!prop.canInteract(state, player.field_70170_p, pos, player, leftClick, side, this.id, client)) {
                this.sendMessage(this.getNextID(prop.getID(), keys), prop, player);
                return false;
            }
            this.getNextID(prop.getID(), keys);
        }
        return true;
    }

    private void sendMessage(String id, IResourceCondition condition, EntityPlayer player) {
        String result = this.messages.getOrDefault(id, this.globalError);
        if (result == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(result), true);
    }

    private String getNextID(String id, Set<String> storage) {
        String result = id;
        int index = 1;
        while (storage.contains(result)) {
            result = id + "_" + index;
            ++index;
        }
        storage.add(result);
        return result;
    }

    @Override
    public String getID() {
        return this.id;
    }
}

