/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.utils;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.utils.LootUtil;

public class StackObject {
    Item item;
    int meta;
    int stacksize;
    NBTTagCompound nbt;

    public StackObject(Item item, int meta, int stacksize, NBTTagCompound nbt) {
        this.item = item;
        this.meta = meta;
        this.stacksize = stacksize;
        this.nbt = nbt;
    }

    public StackObject copy() {
        return new StackObject(this.item, this.meta, this.stacksize, this.nbt);
    }

    public String getName() {
        ItemStack stack = new ItemStack(this.item, 1, this.meta == Short.MAX_VALUE ? 0 : this.meta);
        stack.func_77982_d(this.nbt);
        return stack.func_82833_r();
    }

    public int getStackize() {
        return this.stacksize;
    }

    public void decreaseStackSize(int amount) {
        this.stacksize -= amount;
    }

    public boolean matches(ItemStack stack) {
        return LootUtil.doesStackMatch(stack, this.item, this.meta, this.nbt);
    }

    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public NBTTagCompound getNbt() {
        return this.nbt;
    }
}

