/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.stager.util;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.UUID;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import uk.artdude.zenstages.stager.Stage;

@ZenRegister
@ZenClass(value="mods.zenstages.Utils")
public class Utils {
    private static final String recipeString = "stage_%s_%s";
    public static final String craftTweakerRegex = String.format("%s:%s", "crafttweaker", "stage_%s_%s");

    @ZenMethod
    public static String genRecipeName() {
        return UUID.randomUUID().toString();
    }

    @ZenMethod
    public static String genRecipeName(Stage stage) {
        return String.format(recipeString, Utils.formatStage(stage), UUID.randomUUID().toString());
    }

    @ZenMethod
    public static String genRecipeName(Stage stage, String name) {
        return String.format(recipeString, Utils.formatStage(stage), name);
    }

    @ZenMethod
    public static String genRecipeName(Stage stage, IItemStack itemStack) {
        return String.format(recipeString, Utils.formatStage(stage), Utils.formatItem(itemStack));
    }

    @ZenMethod
    public static String genRecipeName(Stage stage, IItemStack itemStack, String name) {
        return String.format("stage_%s_%s_%s", Utils.formatStage(stage), Utils.formatItem(itemStack), name);
    }

    public static String formatStage(Stage stage) {
        return stage.getStage().replaceAll("\\s+", "_");
    }

    private static String formatItem(IItemStack itemStack) {
        return itemStack.getDisplayName().replaceAll("\\s+", "_").replaceAll("[()]", "").toLowerCase();
    }
}

