/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.stager;

import com.blamejared.recipestages.handlers.Recipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import uk.artdude.zenstages.common.util.Helper;
import uk.artdude.zenstages.stager.DupeChecker;
import uk.artdude.zenstages.stager.Stage;
import uk.artdude.zenstages.stager.type.TypeBase;
import uk.artdude.zenstages.stager.type.TypeContainer;
import uk.artdude.zenstages.stager.type.TypeCustom;
import uk.artdude.zenstages.stager.type.TypeDimension;
import uk.artdude.zenstages.stager.type.TypeIngredient;
import uk.artdude.zenstages.stager.type.TypeMob;
import uk.artdude.zenstages.stager.type.TypeMod;
import uk.artdude.zenstages.stager.type.TypeMultiBlock;
import uk.artdude.zenstages.stager.type.TypeOre;
import uk.artdude.zenstages.stager.type.TypePackage;
import uk.artdude.zenstages.stager.type.TypeRecipeName;
import uk.artdude.zenstages.stager.type.TypeTinker;

@ZenRegister
@ZenClass(value="mods.zenstages.ZenStager")
public class ZenStager {
    private static Map<String, Stage> stageMap = new HashMap<String, Stage>();
    private static List<TypeCustom> customTypes = new ArrayList<TypeCustom>();
    public static List<IIngredient> stagingOverrides = new ArrayList<IIngredient>();

    @ZenMethod
    public static Stage initStage(String name) {
        if (name == null || name.length() < 1) {
            CraftTweakerAPI.logError((String)String.format("[ZenStager] Name %s cannot be null or less than one!", name));
            return null;
        }
        String safeName = Helper.cleanName(name);
        if (stageMap.containsKey(safeName)) {
            CraftTweakerAPI.logError((String)String.format("[ZenStager] Failed to create stage %s due to name already existing.", safeName));
            return null;
        }
        Stage stage = new Stage(safeName);
        stageMap.put(safeName, stage);
        return stage;
    }

    @ZenMethod
    public static TypeCustom initCustomType(String name, String value) {
        return ZenStager.createCustomType(name, value);
    }

    @ZenMethod
    public static TypeCustom initCustomType(String name, String[] value) {
        return ZenStager.createCustomType(name, value);
    }

    @ZenMethod
    public static TypeCustom initCustomType(String name, int value) {
        return ZenStager.createCustomType(name, value);
    }

    @ZenMethod
    public static TypeCustom initCustomType(String name, int[] value) {
        return ZenStager.createCustomType(name, value);
    }

    @ZenMethod
    public static TypeCustom initCustomType(String name, IIngredient value) {
        return ZenStager.createCustomType(name, value);
    }

    @ZenMethod
    public static TypeCustom initCustomType(String name, IIngredient[] value) {
        return ZenStager.createCustomType(name, value);
    }

    @ZenMethod
    public static void addPackage(String packageName, Stage[] stages) {
        for (Stage stage : stages) {
            stage.addPackage(packageName);
        }
    }

    @ZenMethod
    public static void addContainer(String containerName, Stage[] stages) {
        for (Stage stage : stages) {
            stage.addContainer(containerName);
        }
    }

    @ZenMethod
    public TypeCustom getCustomType(String name) {
        for (TypeCustom customType : customTypes) {
            if (!customType.getName().endsWith(name)) continue;
            return customType;
        }
        return null;
    }

    @ZenMethod
    public static Map<String, Stage> getStageMap() {
        return stageMap;
    }

    @ZenMethod
    public static Stage getStage(String stage) {
        return stageMap.get(stage.toLowerCase());
    }

    @ZenMethod
    public static Stage getIngredientStage(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        for (Stage stage : stageMap.values()) {
            if (!stage.isIngredientStaged(ingredient)) continue;
            return stage;
        }
        return null;
    }

    @ZenMethod
    public static Stage getLiquidStage(ILiquidStack liquidStack) {
        return ZenStager.getIngredientStage((IIngredient)liquidStack);
    }

    @ZenMethod
    public static Map<Stage, ILiquidStack[]> getStagedLiquids() {
        HashMap<Stage, ILiquidStack[]> liquidStacks = new HashMap<Stage, ILiquidStack[]>();
        for (Stage stage : stageMap.values()) {
            List<ILiquidStack> liquidStackList = stage.getStagedLiquids();
            if (liquidStackList.size() < 1) continue;
            ILiquidStack[] fluidStacks = new ILiquidStack[]{};
            fluidStacks = liquidStackList.toArray(fluidStacks);
            liquidStacks.put(stage, fluidStacks);
        }
        return liquidStacks;
    }

    @ZenMethod
    public static Stage getRecipeNameStage(String recipeName) {
        for (Stage stage : stageMap.values()) {
            if (stage.getRecipeNameStage(recipeName) == null) continue;
            return stage;
        }
        return null;
    }

    @ZenMethod
    public static Stage getDimensionStage(int dimension) {
        for (Stage stage : stageMap.values()) {
            if (stage.getDimensionStage(dimension) == null) continue;
            return stage;
        }
        return null;
    }

    @ZenMethod
    public static List<Stage> getContainerStages(String container) {
        HashMap<String, List<String>> stagesForType = new HashMap<String, List<String>>();
        ZenStager.getStagesForType(TypeContainer.class, stagesForType);
        List stages = (List)stagesForType.get(container);
        if (stages == null) {
            return null;
        }
        return stages.stream().map(t -> stageMap.get(t)).collect(Collectors.toList());
    }

    @ZenMethod
    public static List<Stage> getPackageStages(String packageName) {
        HashMap<String, List<String>> stagesForType = new HashMap<String, List<String>>();
        ZenStager.getStagesForType(TypePackage.class, stagesForType);
        List stages = (List)stagesForType.get(packageName);
        if (stages == null) {
            return null;
        }
        return stages.stream().map(t -> stageMap.get(t)).collect(Collectors.toList());
    }

    @ZenMethod
    public static Stage getMobStage(String mobName) {
        for (Stage stage : stageMap.values()) {
            if (stage.getMobStage(mobName) == null) continue;
            return stage;
        }
        return null;
    }

    @ZenMethod
    public static Stage getTiCMaterialStage(String material) {
        for (Stage stage : stageMap.values()) {
            if (stage.getTiCMaterialStage(material) == null) continue;
            return stage;
        }
        return null;
    }

    @ZenMethod
    public static Stage getTiCToolStage(String toolName) {
        for (Stage stage : stageMap.values()) {
            if (stage.getTiCToolStage(toolName) == null) continue;
            return stage;
        }
        return null;
    }

    @ZenMethod
    public static Stage getCustomStage(String slug, String value) {
        return ZenStager.getCustomTypeStage(slug, value);
    }

    @ZenMethod
    public static Stage getCustomStage(String slug, int value) {
        return ZenStager.getCustomTypeStage(slug, value);
    }

    @ZenMethod
    public static Stage getCustomStage(String slug, IIngredient value) {
        return ZenStager.getCustomTypeStage(slug, value);
    }

    @ZenMethod
    public static boolean isStaged(String slug, String value) {
        switch (slug.toLowerCase()) {
            case "container": {
                return ZenStager.getStageForType(TypeContainer.class, value) != null;
            }
            case "mod": {
                return ZenStager.getStageForType(TypeMod.class, value) != null;
            }
            case "multiblock": {
                return ZenStager.getStageForType(TypeMultiBlock.class, value) != null;
            }
            case "package": {
                return ZenStager.getStageForType(TypePackage.class, value) != null;
            }
            case "recipename": {
                return ZenStager.getStageForType(TypeRecipeName.class, value) != null;
            }
            case "tinker": {
                return ZenStager.getStageForType(TypeTinker.class, value) != null;
            }
            case "mob": {
                return ZenStager.getStageForType(TypeMob.class, value) != null;
            }
        }
        return ZenStager.hasCustomType(slug, value);
    }

    @ZenMethod
    public static boolean isStaged(String slug, int value) {
        switch (slug.toLowerCase()) {
            case "dimension": {
                return ZenStager.getStageForType(TypeDimension.class, value) != null;
            }
        }
        return ZenStager.hasCustomType(slug, value);
    }

    @ZenMethod
    public static boolean isStaged(String slug, IIngredient value) {
        switch (slug.toLowerCase()) {
            case "ingredient": {
                return ZenStager.getStageForType(TypeIngredient.class, value) != null;
            }
            case "ore": {
                return ZenStager.getStageForType(TypeOre.class, value) != null;
            }
        }
        return ZenStager.hasCustomType(slug, value);
    }

    @ZenMethod
    public static void checkConflicts() {
        CraftTweakerAPI.logInfo((String)"[Stage Duplicate] Starting duplicate checks....");
        DupeChecker.checkForDupes(stageMap);
        DupeChecker.logDupes();
        CraftTweakerAPI.logInfo((String)"[Stage Duplicate] Completed duplicate checks!");
    }

    @ZenMethod
    public static void buildAll() {
        CraftTweakerAPI.logInfo((String)String.format("[ZenStager] Starting build for %s stages...", stageMap.size()));
        HashMap stagedTypes = new HashMap();
        stagedTypes.put("CONTAINER", new HashMap());
        stagedTypes.put("PACKAGE", new HashMap());
        stageMap.forEach((s, stage) -> {
            ZenStager.getStagesForType(TypeContainer.class, (Map)stagedTypes.get("CONTAINER"), stage);
            ZenStager.getStagesForType(TypePackage.class, (Map)stagedTypes.get("PACKAGE"), stage);
            stage.build();
        });
        CraftTweakerAPI.logInfo((String)"[ZenStager] Starting building the recipe stage setting...");
        stageMap.forEach((s, stage) -> stage.buildRecipe());
        CraftTweakerAPI.logInfo((String)"[ZenStager] Completed building the recipe stage setting!");
        Map stagedContainers = (Map)stagedTypes.get("CONTAINER");
        stagedContainers.forEach((container, stages) -> {
            String[] forStages = new String[]{};
            forStages = stages.toArray(forStages);
            Recipes.setContainerStage((String)container, (String[])forStages);
        });
        Map stagedPackages = (Map)stagedTypes.get("PACKAGE");
        stagedPackages.forEach((packageName, stages) -> {
            String[] forStages = new String[]{};
            forStages = stages.toArray(forStages);
            Recipes.setPackageStage((String)packageName, (String[])forStages);
        });
        CraftTweakerAPI.logInfo((String)String.format("[ZenStager] Completed build for %s stages!", stageMap.size()));
    }

    private static <T> TypeCustom createCustomType(String name, T value) {
        String safeName = Helper.cleanName(name);
        CraftTweakerAPI.logInfo((String)String.format("[ZenStager] Custom Type has been created with the name `%s` use this when accessing a type via the scripts!", safeName));
        TypeCustom<T> customType = new TypeCustom<T>(safeName, value);
        customTypes.add(customType);
        return customType;
    }

    private static <T> Stage getCustomTypeStage(String slug, T value) {
        List<TypeCustom> customTypes = ZenStager.filterCustomByName(slug);
        for (TypeCustom customType : customTypes) {
            if (customType == null || customType.getStage() == null) continue;
            if (customType.getValue() instanceof IIngredient[] && Arrays.asList((Object[])customType.getValue()).contains(value)) {
                return customType.getStage();
            }
            if (!customType.getValue().equals(value)) continue;
            return customType.getStage();
        }
        return null;
    }

    private static <T> boolean hasCustomType(String slug, T value) {
        List<TypeCustom> customTypes = ZenStager.filterCustomByName(slug);
        for (TypeCustom customType : customTypes) {
            if (customType.getValue() instanceof IIngredient[] && Arrays.asList((Object[])customType.getValue()).contains(value)) {
                return true;
            }
            if (!customType.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    static List<TypeCustom> filterCustomByStage(Stage stage, String slug) {
        return customTypes.stream().filter(t -> t.getStage() == stage && t.getName().equalsIgnoreCase(slug)).collect(Collectors.toList());
    }

    private static List<TypeCustom> filterCustomByName(String name) {
        return customTypes.stream().filter(t -> t.getName().equalsIgnoreCase(name)).collect(Collectors.toList());
    }

    private static <T extends TypeBase> void getStagesForType(Class<T> clazz, Map<String, List<String>> stringListMap) {
        stageMap.forEach((s, stage) -> ZenStager.getStagesForType(clazz, stringListMap, stage));
    }

    private static <T extends TypeBase> void getStagesForType(Class<T> clazz, Map<String, List<String>> stringListMap, Stage stage) {
        for (TypeBase stagedType : stage.filterEntries(clazz)) {
            if (stringListMap.containsKey(stagedType.getValue())) {
                List<String> currentStages = stringListMap.get(stagedType.getValue());
                currentStages.add(stage.getStage());
                continue;
            }
            ArrayList<String> stages = new ArrayList<String>();
            stages.add(stage.getStage());
            stringListMap.put(stagedType.getValue().toString(), stages);
        }
    }

    private static <T extends TypeBase, J> Stage getStageForType(Class<T> clazz, J value) {
        for (Stage stage : stageMap.values()) {
            if (stage.getStage(clazz, value) == null) continue;
            return stage;
        }
        return null;
    }
}

