/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.ench.EnchModule;

public class ItemTypedBook
extends ItemBook {
    final ItemStack rep;
    final EnumEnchantmentType type;

    public ItemTypedBook(Item rep, EnumEnchantmentType type) {
        this.type = type;
        this.rep = new ItemStack(rep);
        this.setRegistryName("apotheosis", (type == null ? "null" : type.name().toLowerCase(Locale.ROOT)) + "_book");
        this.func_77655_b("apotheosis." + this.getRegistryName().func_110623_a());
        this.func_77637_a(CreativeTabs.field_78026_f);
        EnchModule.TYPED_BOOKS.add(this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == this.type || enchantment.canApplyAtEnchantingTable(this.rep);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)("info.apotheosis." + this.getRegistryName().func_110623_a()), (Object[])new Object[0]));
    }

    public static void updateAnvil(AnvilUpdateEvent ev) {
        ItemStack book = ev.getRight();
        ItemStack weapon = ev.getLeft();
        if (!book.func_77948_v() || !weapon.func_77973_b().func_77616_k(weapon)) {
            return;
        }
        Map bookEnch = EnchantmentHelper.func_82781_a((ItemStack)book);
        Map wepEnch = EnchantmentHelper.func_82781_a((ItemStack)weapon);
        int cost = 0;
        for (Enchantment ench : bookEnch.keySet()) {
            int curLevel;
            if (ench == null) continue;
            int level = bookEnch.containsKey(ench) ? (Integer)bookEnch.get(ench) : 0;
            int n = curLevel = wepEnch.containsKey(ench) ? (Integer)wepEnch.get(ench) : 0;
            if (level > 0 && level == curLevel) {
                level = Math.min(EnchModule.getEnchInfo(ench).getMaxLevel(), level + 1);
            }
            if (curLevel > level) {
                level = curLevel;
            }
            if (!ench.func_92089_a(weapon)) continue;
            boolean isCompat = true;
            for (Enchantment ench2 : wepEnch.keySet()) {
                if (ench == ench2 || ench.func_191560_c(ench2)) continue;
                isCompat = false;
            }
            if (!isCompat) {
                return;
            }
            wepEnch.put(ench, level);
            int addition = 0;
            switch (ench.func_77324_c()) {
                case COMMON: {
                    addition += 1 * level;
                    break;
                }
                case UNCOMMON: {
                    addition += 2 * level;
                    break;
                }
                case RARE: {
                    addition += 4 * level;
                    break;
                }
                case VERY_RARE: {
                    addition += 8 * level;
                }
            }
            cost += Math.max(1, addition / 2);
        }
        if (cost > 0) {
            ItemStack out = weapon.func_77946_l();
            out.func_82841_c(weapon.func_82838_A() * 2 + 1);
            EnchantmentHelper.func_82782_a((Map)wepEnch, (ItemStack)out);
            ev.setMaterialCost(1);
            ev.setCost(cost += weapon.func_82838_A());
            ev.setOutput(out);
        }
    }
}

