/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench;

import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import net.minecraft.enchantment.Enchantment;

public class EnchantmentInfo {
    final Enchantment ench;
    final int maxLevel;
    final int minLevel;
    PowerFunc maxPower;
    PowerFunc minPower;

    public EnchantmentInfo(Enchantment ench, int maxLevel, int minLevel) {
        this.ench = ench;
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
        this.maxPower = level -> ench.func_77317_b(level);
        this.minPower = level -> ench.func_77321_a(level);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMinPower(int level) {
        return this.minPower.getPower(level);
    }

    public int getMaxPower(int level) {
        return this.maxPower.getPower(level);
    }

    public void setMaxPower(PowerFunc maxPower) {
        this.maxPower = maxPower;
    }

    public void setMinPower(PowerFunc minPower) {
        this.minPower = minPower;
    }

    public static class ExpressionPowerFunc
    implements PowerFunc {
        Expression ex;

        public ExpressionPowerFunc(String func) {
            this.ex = new Expression(func);
        }

        @Override
        public int getPower(int level) {
            return this.ex.setVariable("x", new BigDecimal(level)).eval().intValue();
        }
    }

    public static interface PowerFunc {
        public int getPower(int var1);
    }
}

