/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shadows.deadly.DeadlyLoot;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.config.DeadlyConstants;
import shadows.deadly.gen.SpawnerItem;
import shadows.deadly.gen.WorldFeature;
import shadows.deadly.gen.WorldGenerator;
import shadows.util.ChestBuilder;

public class SwarmSpawner
extends WorldFeature {
    public static final ArrayList<SpawnerItem> SWARM_SPAWNERS = new ArrayList();

    @Override
    public void generate(World world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.swarmSpawnerChance <= rand.nextDouble()) {
            return;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, y, z);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (!this.canBePlaced(world, (BlockPos)mPos.func_181079_c(x, y, z), rand)) continue;
            this.place(world, (BlockPos)mPos.func_181079_c(x, y, z), rand);
            WorldGenerator.SUCCESSES.add(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
            return;
        }
    }

    @Override
    public boolean canBePlaced(World world, BlockPos pos, Random rand) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && WorldGenerator.STONE_TEST.apply((Object)world.func_180495_p(pos)) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a());
    }

    @Override
    public void place(World world, BlockPos pos, Random rand) {
        ChestBuilder.place(world, rand, pos.func_177977_b(), rand.nextInt(12) == 0 ? DeadlyLoot.CHEST_VALUABLE : DeadlyLoot.SPAWNER_SWARM);
        ((SpawnerItem)WeightedRandom.func_76271_a((Random)rand, SWARM_SPAWNERS)).place(world, pos);
        world.func_180501_a(pos.func_177984_a(), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 2);
        WorldGenerator.debugLog(pos, "Swarm Spawner");
    }

    @Override
    public boolean isEnabled() {
        return !DeadlyConfig.SWARM_MOBS.isEmpty() && DeadlyConfig.swarmSpawnerChance > 0.0f;
    }

    public static void init() {
        SpawnerItem.addItems(SWARM_SPAWNERS, DeadlyConstants.SWARM_SPAWNER_STATS, DeadlyConfig.SWARM_MOBS);
    }
}

