/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import shadows.deadly.config.DeadlyConstants;
import shadows.deadly.gen.WorldFeature;
import shadows.placebo.util.SpawnerBuilder;
import shadows.util.SpawnerStats;
import shadows.util.TagBuilder;

public class SpawnerItem
extends WorldFeature.WorldFeatureItem {
    protected final SpawnerBuilder spawner;

    public SpawnerItem(SpawnerBuilder spawner, int weight) {
        super(weight);
        this.spawner = spawner;
    }

    public static void addItems(List<SpawnerItem> items, SpawnerStats stats, List<Pair<Integer, ResourceLocation>> weightMobPairs) {
        for (Pair<Integer, ResourceLocation> pair : weightMobPairs) {
            SpawnerBuilder builder = new SpawnerBuilder();
            builder.setType((ResourceLocation)pair.getRight());
            if (((ResourceLocation)pair.getRight()).equals((Object)DeadlyConstants.RANDOM)) {
                builder = TagBuilder.createMobSpawnerRandom();
            }
            stats.apply(builder);
            TagBuilder.checkForSkeleton(builder.getSpawnData());
            items.add(new SpawnerItem(builder, (Integer)pair.getLeft()));
        }
    }

    @Override
    public void place(World world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        world.func_175690_a(pos, (TileEntity)this.spawner.build(world, pos));
    }

    public SpawnerBuilder getSpawner() {
        return this.spawner;
    }
}

