/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.shared.config;

import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quaternary.botaniatweaks.modules.shared.config.BotaniaTweaksConfig;

public class ConfigUpdater {
    public static final int CONFIG_FILE_VERSION = 6;
    private static final Logger LOG = LogManager.getLogger((String)"Botania Tweaks Config Auto-Updater");

    private static void log(String message) {
        LOG.info(message);
    }

    static void updateConfig(Configuration config) {
        int version;
        try {
            String s = config.getLoadedConfigVersion();
            version = s == null ? 0 : Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Problem parsing configuration file version number! \"" + config.getLoadedConfigVersion() + "\" doesn't look like a valid integer");
        }
        if (version > 6) {
            throw new IllegalArgumentException("This version " + version + " config file is from the future! I only know about config file versions up to " + 6 + "!");
        }
        boolean dirtyConfig = false;
        if (version <= 1) {
            ConfigUpdater.updatev1tov2(config);
            version = 2;
            dirtyConfig = true;
        }
        if (version <= 2) {
            ConfigUpdater.updatev2tov3(config);
            version = 3;
            dirtyConfig = true;
        }
        if (version <= 3) {
            ConfigUpdater.updatev3tov4(config);
            version = 4;
            dirtyConfig = true;
        }
        if (version <= 4) {
            ConfigUpdater.updatev4tov5(config);
            version = 5;
            dirtyConfig = true;
        }
        if (version <= 5) {
            ConfigUpdater.updatev5tov6(config);
            version = 6;
            dirtyConfig = true;
        }
        if (dirtyConfig) {
            BotaniaTweaksConfig.readConfig();
        }
    }

    private static void updatev1tov2(Configuration config) {
        ConfigUpdater.log("Updating version 1 config to version 2");
        if (config.hasKey("compat", "dootableAgricraft")) {
            if (Loader.isModLoaded((String)"agricraft")) {
                ConfigUpdater.log("Moving the dootable Agricraft config to its new location");
                config.moveProperty("compat", "dootableAgricraft", "compat.agricraft");
            } else {
                ConfigUpdater.log("Removing the dootable Agricraft config since you don't have it loaded");
                config.getCategory("compat").remove((Object)"dootableAgricraft");
            }
        }
        if (config.hasKey("balance", "superEntropinnyum")) {
            ConfigUpdater.log("Replacing the super entropinnyum tweak with the \"cheap flint-to-gunpowder\" tweak");
            boolean wasEnabled = config.getBoolean("superEntropinnyum", "balance", false, "");
            config.get("balance", "cheapFlintToPowder", false).set(wasEnabled);
            config.getCategory("balance").remove((Object)"superEntropinnyum");
        }
        if (config.hasKey("balance.tnt", "allowEntropinnyumDuplicatedTNT")) {
            ConfigUpdater.log("Flipping around the entropinnyum tnt config (from allow to deny)");
            boolean wasAllowed = config.getBoolean("allowEntropinnyumDuplicatedTNT", "balance.tnt", false, "");
            config.get("balance.tnt", "denyEntropinnyumDuplicatedTNT", false).set(!wasAllowed);
            config.getCategory("balance.tnt").remove((Object)"allowEntropinnyumDuplicatedTNT");
        }
        ConfigUpdater.removeKeyIfExists(config, "balance", "corporeaSpork", "Removing the corporea spork config option, since the spork was removed");
        ConfigUpdater.removeKeyIfExists(config, "etc", "pottedTinyPotato", "Removing the potted tiny potato config option (it's just always on now)");
    }

    private static void updatev2tov3(Configuration config) {
        ConfigUpdater.log("Updating version 2 config to version 3");
        ConfigUpdater.removeKeyIfExists(config, "balance.decay.flowers", "hydroangeasDecay", "Removing mistakenly-added hydroangeas decay configuration");
    }

    private static void updatev3tov4(Configuration config) {
        ConfigUpdater.log("Updating version 3 config to version 4");
        ConfigUpdater.removeCategoryIfExists(config, "compat.agricraft", "Removing Agricraft compat config category, since Agricraft added the Horn of the Wild compat itself :D");
        ConfigUpdater.removeCategoryIfExists(config, "compat.avaritia", "Removing Avaritia compat category, since I just always register the crafty crate now");
        ConfigUpdater.removeCategoryIfExists(config, "compat.extendedcrafting", "Removing the Extended Crafting category, since I just always register the crafty crates now");
    }

    private static void updatev4tov5(Configuration config) {
        ConfigUpdater.log("Updating version 4 config to version 5");
        ConfigUpdater.removeKeyIfExists(config, "etc", "nbtAwareAltarAndApothecary", "Removing the NBT Aware Altar and Apothecary option since it was merged in to Botania mainline");
        ConfigUpdater.removeKeyIfExists(config, "etc", "unlockApothecary", "Removing the Unlock Apothecary option since it was merged in to Botania mainline");
        ConfigUpdater.removeKeyIfExists(config, "balance", "superSpectrolus", "Removing the Super Spectrolus option since it was merged in to Botania mainline");
        ConfigUpdater.removeKeyIfExists(config, "balance", "cheapFlintToPowder", "Removing the Cheap Flint to Gunpowder option since it was merged in to Botania mainline");
    }

    private static void updatev5tov6(Configuration config) {
        ConfigUpdater.log("Updating version 5 config to version 6");
        ConfigUpdater.removeKeyIfExists(config, "etc", "tillAltGrass", "Removing tillAltGrass since it was merged in to Botania mainline");
        ConfigUpdater.removeKeyIfExists(config, "etc", "tillCustomGrass", "Xd");
    }

    private static void removeCategoryIfExists(Configuration config, String category, String comment) {
        if (config.hasCategory(category)) {
            ConfigUpdater.log(comment);
            config.removeCategory(config.getCategory(category));
        }
    }

    private static void removeKeyIfExists(Configuration config, String category, String key, String comment) {
        if (config.hasKey(category, key)) {
            ConfigUpdater.log(comment);
            ConfigCategory cat = config.getCategory(category);
            cat.remove((Object)key);
        }
    }
}

