/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.shared.config;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import quaternary.botaniatweaks.BotaniaTweaks;
import quaternary.botaniatweaks.modules.IModule;
import quaternary.botaniatweaks.modules.shared.config.ConfigUpdater;

@Mod.EventBusSubscriber(modid="botania_tweaks")
public class BotaniaTweaksConfig {
    public static Configuration config;

    public static void initConfig() {
        config = new Configuration(new File(Loader.instance().getConfigDir(), "botaniatweaks.cfg"), String.valueOf(6));
        config.load();
        BotaniaTweaksConfig.readConfig();
        ConfigUpdater.updateConfig(config);
    }

    public static void readConfig() {
        for (IModule m : BotaniaTweaks.modules) {
            m.readConfig(config);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static <T extends Enum<T>> T getEnum(Configuration config, String configName, String configCategory, T defaultValue, String configDescription, Function<T, String> describerFunction, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        String[] enumNames = (String[])Arrays.stream(enumConstants).map(Enum::toString).toArray(String[]::new);
        String configAndValueDescription = configDescription + "\n" + Arrays.stream(enumConstants).map(t -> "\"" + t.toString() + "\": " + (String)describerFunction.apply(t)).reduce((one, two) -> one + '\n' + two).get();
        String userProvidedString = config.getString(configName, configCategory, defaultValue.toString(), configAndValueDescription, enumNames);
        Optional<Enum> userEnum = Arrays.stream(enumConstants).filter(t -> t.toString().equals(userProvidedString)).findAny();
        if (userEnum.isPresent()) {
            return (T)userEnum.get();
        }
        throw new IllegalArgumentException("\"" + userProvidedString + "\" is not a valid value for config option " + configName + "! See the config file for details");
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent e) {
        if (e.getModID().equals("botania_tweaks")) {
            BotaniaTweaksConfig.readConfig();
        }
    }
}

