/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipe;
import quaternary.botaniatweaks.modules.shared.helper.MiscHelpers;
import vazkii.botania.client.core.handler.HUDHandler;

public class RecipeWrapperAgglomeration
implements IRecipeWrapper {
    AgglomerationRecipe recipe;
    List<List<ItemStack>> inputs;
    List<ItemStack> outputs;
    ItemStack multiblockCenterStack;
    ItemStack multiblockEdgeStack;
    ItemStack multiblockCornerStack;
    @Nullable
    ItemStack multiblockReplaceCenterStack;
    @Nullable
    ItemStack multiblockReplaceEdgeStack;
    @Nullable
    ItemStack multiblockReplaceCornerStack;
    int manaCost;

    public RecipeWrapperAgglomeration(AgglomerationRecipe recipe) {
        this.recipe = recipe;
        ImmutableList.Builder inputs_ = ImmutableList.builder();
        for (ItemStack stack : recipe.getRecipeStacks()) {
            inputs_.add((Object)ImmutableList.of((Object)stack));
        }
        for (String key : recipe.getRecipeOreKeys()) {
            inputs_.add((Object)ImmutableList.copyOf((Collection)OreDictionary.getOres((String)key)));
        }
        this.multiblockCenterStack = MiscHelpers.stackFromState(recipe.multiblockCenter);
        this.multiblockEdgeStack = MiscHelpers.stackFromState(recipe.multiblockEdge);
        this.multiblockCornerStack = MiscHelpers.stackFromState(recipe.multiblockCorner);
        inputs_.add((Object)ImmutableList.of((Object)this.multiblockCenterStack));
        inputs_.add((Object)ImmutableList.of((Object)this.multiblockEdgeStack));
        inputs_.add((Object)ImmutableList.of((Object)this.multiblockCornerStack));
        ImmutableList.Builder outputs_ = ImmutableList.builder();
        outputs_.add((Object)recipe.getRecipeOutputCopy());
        if (recipe.multiblockCenterReplace != null) {
            this.multiblockReplaceCenterStack = MiscHelpers.stackFromState(recipe.multiblockCenterReplace);
            outputs_.add((Object)this.multiblockReplaceCenterStack);
        }
        if (recipe.multiblockEdgeReplace != null) {
            this.multiblockReplaceEdgeStack = MiscHelpers.stackFromState(recipe.multiblockEdgeReplace);
            outputs_.add((Object)this.multiblockReplaceEdgeStack);
        }
        if (recipe.multiblockCornerReplace != null) {
            this.multiblockReplaceCornerStack = MiscHelpers.stackFromState(recipe.multiblockCornerReplace);
            outputs_.add((Object)this.multiblockReplaceCornerStack);
        }
        this.inputs = inputs_.build();
        this.outputs = outputs_.build();
        this.manaCost = recipe.manaCost;
    }

    public void getIngredients(IIngredients ing) {
        ing.setInputLists(VanillaTypes.ITEM, this.inputs);
        ing.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GlStateManager.func_179141_d();
        HUDHandler.renderManaBar((int)35, (int)60, (int)255, (float)0.75f, (int)this.manaCost, (int)1000000);
        if (this.manaCost > 1000000) {
            int roughPoolCount = 250000 * Math.round((float)this.manaCost / 250000.0f) / 1000000;
            Minecraft.func_71410_x().field_71466_p.func_78276_b("x" + roughPoolCount, 140, 58, 0);
        }
        GlStateManager.func_179118_c();
    }
}

