/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import quaternary.botaniatweaks.modules.jei.RecipeWrapperAgglomeration;
import quaternary.botaniatweaks.modules.shared.helper.ModCompatUtil;

public class RecipeCategoryCustomAgglomeration
implements IRecipeCategory<RecipeWrapperAgglomeration> {
    public static final String UID = "botaniatweaks.agglomeration";
    static final int WIDTH = 170;
    static final int HEIGHT = 130;
    final String localizedName = I18n.func_135052_a((String)"botania_tweaks.jei.agglomeration.category", (Object[])new Object[0]);
    final IDrawable background;
    static final int ITEM_WIDTH = 16;
    static final int ITEM_HEIGHT = 16;
    static final int ITEM_BUFFER = 4;

    public RecipeCategoryCustomAgglomeration(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("botania_tweaks", "textures/ui/terrasteeloverlay.png"), 0, 0, 170, 130);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Botania Tweaks";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout layout, RecipeWrapperAgglomeration wrapper, IIngredients ings) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List ins = ings.getInputs(VanillaTypes.ITEM);
        List itemInputs = ins.subList(0, ins.size() - 3);
        List outs = ings.getOutputs(VanillaTypes.ITEM);
        int index = 0;
        int inputCount = itemInputs.size();
        int totalInputWidth = 16 * inputCount + 4 * (inputCount - 1);
        int posX = 85 - totalInputWidth / 2;
        int posY = 0;
        for (List in : itemInputs) {
            stacks.init(index, true, posX, posY);
            stacks.set(index, in);
            ++index;
            posX += 20;
        }
        List outItem = (List)outs.get(0);
        stacks.init(index, false, 77, posY += 36);
        stacks.set(index, outItem);
        ++index;
        posY = (int)((double)posY + 67.0);
        ItemStack centerReplace = wrapper.multiblockReplaceCenterStack;
        ItemStack edgeReplace = wrapper.multiblockReplaceEdgeStack;
        ItemStack cornerReplace = wrapper.multiblockReplaceCornerStack;
        boolean isCenterReplaced = true;
        boolean isEdgeReplaced = true;
        boolean isCornerReplaced = true;
        if (centerReplace == null) {
            isCenterReplaced = false;
            centerReplace = ItemStack.field_190927_a;
        }
        if (edgeReplace == null) {
            isEdgeReplaced = false;
            edgeReplace = ItemStack.field_190927_a;
        }
        if (cornerReplace == null) {
            isCornerReplaced = false;
            cornerReplace = ItemStack.field_190927_a;
        }
        if (!(isCenterReplaced || isEdgeReplaced || isCornerReplaced)) {
            this.setMultiblock(index, stacks, (List<ItemStack>)ImmutableList.of((Object)wrapper.multiblockCenterStack), (List<ItemStack>)ImmutableList.of((Object)wrapper.multiblockEdgeStack), (List<ItemStack>)ImmutableList.of((Object)wrapper.multiblockCornerStack), 85, posY, false, false, false);
        } else {
            index = this.setMultiblock(index, stacks, (List<ItemStack>)ImmutableList.of((Object)wrapper.multiblockCenterStack), (List<ItemStack>)ImmutableList.of((Object)wrapper.multiblockEdgeStack), (List<ItemStack>)ImmutableList.of((Object)wrapper.multiblockCornerStack), 36, posY, false, false, false);
            ImmutableList drawCenter = ImmutableList.of((Object)(isCenterReplaced ? centerReplace : wrapper.multiblockCenterStack));
            ImmutableList drawEdge = ImmutableList.of((Object)(isEdgeReplaced ? edgeReplace : wrapper.multiblockEdgeStack));
            ImmutableList drawCorner = ImmutableList.of((Object)(isCornerReplaced ? cornerReplace : wrapper.multiblockCornerStack));
            this.setMultiblock(index, stacks, (List<ItemStack>)drawCenter, (List<ItemStack>)drawEdge, (List<ItemStack>)drawCorner, 132, posY, isCenterReplaced, isEdgeReplaced, isCornerReplaced);
        }
    }

    static boolean empty(List<ItemStack> list) {
        return list.isEmpty();
    }

    int setMultiblock(int index, IGuiItemStackGroup stacks, List<ItemStack> center, List<ItemStack> edges, List<ItemStack> corners, int posX, int posY, boolean centerOutput, boolean edgeOutput, boolean cornerOutput) {
        stacks.init(index, false, posX - 8, posY - MathHelper.func_76128_c((double)40.0));
        stacks.set(index, ModCompatUtil.getStackFor(new ResourceLocation("botania", "terraplate")));
        ++index;
        if (!RecipeCategoryCustomAgglomeration.empty(center)) {
            stacks.init(index, centerOutput, posX - 8, posY - 8);
            stacks.set(index, center);
            ++index;
        }
        if (!RecipeCategoryCustomAgglomeration.empty(edges)) {
            stacks.init(index, edgeOutput, posX - MathHelper.func_76128_c((double)24.0), posY - 16);
            stacks.set(index, edges);
            stacks.init(++index, edgeOutput, posX + 8, posY - 16);
            stacks.set(index, edges);
            stacks.init(++index, edgeOutput, posX - MathHelper.func_76128_c((double)24.0), posY);
            stacks.set(index, edges);
            stacks.init(++index, edgeOutput, posX + 8, posY);
            stacks.set(index, edges);
            ++index;
        }
        if (!RecipeCategoryCustomAgglomeration.empty(corners)) {
            stacks.init(index, cornerOutput, posX - MathHelper.func_76128_c((double)40.0), posY - 8);
            stacks.set(index, corners);
            stacks.init(++index, cornerOutput, posX + MathHelper.func_76128_c((double)24.0), posY - 8);
            stacks.set(index, corners);
            stacks.init(++index, cornerOutput, posX - 8, posY - MathHelper.func_76128_c((double)24.0));
            stacks.set(index, corners);
            stacks.init(++index, cornerOutput, posX - 8, posY + 8);
            stacks.set(index, corners);
            ++index;
        }
        return index;
    }
}

