/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.dynamictrees;

import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import quaternary.botaniatweaks.BotaniaTweaks;
import quaternary.botaniatweaks.modules.IModule;
import vazkii.botania.common.block.ModBlocks;

public class ModuleDynamicTrees
implements IModule {
    public static boolean altGrassTrees = false;

    @Override
    public void readConfig(Configuration config) {
        Property proop = config.get("compat.dynamictrees", "customGrassTrees", true, "Should you be able to plant trees from Dynamic Trees on other Botania grasses?");
        proop.setRequiresMcRestart(true);
        altGrassTrees = proop.getBoolean();
    }

    @Override
    public void init() {
        if (altGrassTrees) {
            BotaniaTweaks.LOG.info("Expanding Dynamic Trees's definition of grass to include Botania variant grasses too...");
            GameRegistry.findRegistry(Species.class).forEach(s -> {
                try {
                    HashSet treeSoils = (HashSet)ReflectionHelper.getPrivateValue(Species.class, (Object)s, (String[])new String[]{"soilList"});
                    if (treeSoils.contains(Blocks.field_150349_c)) {
                        treeSoils.add(ModBlocks.altGrass);
                    }
                }
                catch (Exception e) {
                    BotaniaTweaks.LOG.error("Problem doing hacky dynamic trees reflective access stuff. More details follow. For now I'll just assume that the sapling " + s.getRegistryName() + " can in fact be planted on botania grass variants. Pls report this as a bug to Botania Tweaks if you see this. Ok the actual error:", (Throwable)e);
                    s.addAcceptableSoil(new Block[]{ModBlocks.altGrass});
                }
            });
        }
    }
}

