/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import quaternary.botaniatweaks.modules.shared.helper.MathUtil;
import vazkii.botania.common.Botania;

public class PacketCustomTerraPlate
implements IMessage {
    int x;
    int y;
    int z;
    int color1;
    int color2;
    float progress;

    public PacketCustomTerraPlate() {
    }

    public PacketCustomTerraPlate(BlockPos pos, int color1, int color2, float progress) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.color1 = color1;
        this.color2 = color2;
        this.progress = progress;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.color1);
        buf.writeInt(this.color2);
        buf.writeFloat(this.progress);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.color1 = buf.readInt();
        this.color2 = buf.readInt();
        this.progress = buf.readFloat();
    }

    public static class Response
    implements IMessageHandler<PacketCustomTerraPlate, IMessage> {
        public IMessage onMessage(PacketCustomTerraPlate message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                int ticks = (int)MathHelper.func_76131_a((float)(message.progress * 100.0f), (float)0.0f, (float)100.0f);
                int totalSpiritCount = 3;
                double tickIncrement = 360.0 / (double)totalSpiritCount;
                int speed = 5;
                double wticks = (double)(ticks * speed) - tickIncrement;
                double r = Math.sin((double)(ticks - 100) / 10.0) * 2.0;
                double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
                for (int ix = 0; ix < totalSpiritCount; ++ix) {
                    double x = (double)message.x + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                    double y = (double)message.y + 0.25 + Math.abs(r) * 0.7;
                    double zx = (double)message.z + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                    wticks += tickIncrement;
                    int color = MathUtil.lerpColor(message.color1, message.color2, message.progress);
                    float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
                    float green = (float)((color & 0xFF00) >> 8) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    Botania.proxy.wispFX(x, y, zx, red, green, blue, 0.85f, (float)g * 0.05f, 0.25f);
                    Botania.proxy.wispFX(x, y, zx, red, green, blue, (float)Math.random() * 0.1f + 0.1f, (float)(Math.random() - 0.5) * 0.05f, (float)(Math.random() - 0.5) * 0.05f, (float)(Math.random() - 0.5) * 0.05f, 0.9f);
                    if (ticks != 100) continue;
                    for (int j = 0; j < 15; ++j) {
                        Botania.proxy.wispFX((double)message.x + 0.5, (double)message.y + 0.5, (double)message.z + 0.5, red, green, blue, (float)Math.random() * 0.15f + 0.15f, (float)(Math.random() - 0.5) * 0.125f, (float)(Math.random() - 0.5) * 0.125f, (float)(Math.random() - 0.5) * 0.125f);
                    }
                }
            });
            return null;
        }
    }
}

