/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.handler;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;

public class TNTDuplicatorDetectionWorldTickHander {
    @SubscribeEvent
    public static void update(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase == TickEvent.Phase.START) {
            return;
        }
        for (EntityTNTPrimed tnt : e.world.func_175644_a(EntityTNTPrimed.class, ent -> true)) {
            TNTDuplicatorDetectionWorldTickHander.processTNTDupe(tnt);
        }
    }

    public static void processTNTDupe(EntityTNTPrimed tnt) {
        World world = tnt.field_70170_p;
        if (tnt.func_184536_l() != 79) {
            return;
        }
        BlockPos tntPos = tnt.func_180425_c();
        int score = 0;
        Iterable nearbyPositions = BlockPos.func_177975_b((BlockPos)tntPos.func_177982_a(-1, -1, -1), (BlockPos)tntPos.func_177982_a(1, 1, 1));
        for (BlockPos pos : nearbyPositions) {
            Block b = TNTDuplicatorDetectionWorldTickHander.getBlockOrMovingBlock(world, pos);
            if (b == Blocks.field_180399_cE) {
                ++score;
            }
            if (b != Blocks.field_150319_E) continue;
            score += 5;
        }
        List nearbyCarts = world.func_72872_a(EntityMinecart.class, new AxisAlignedBB(tntPos.func_177982_a(-2, -2, -2), tntPos.func_177982_a(2, 2, 2)));
        if (!nearbyCarts.isEmpty()) {
            score += 3;
            for (EntityMinecart cart : nearbyCarts) {
                Block atCart = TNTDuplicatorDetectionWorldTickHander.getBlockOrMovingBlock(world, cart.func_180425_c());
                Block belowCart = TNTDuplicatorDetectionWorldTickHander.getBlockOrMovingBlock(world, cart.func_180425_c().func_177977_b());
                if (atCart == Blocks.field_150319_E) {
                    score += 4;
                }
                if (belowCart != Blocks.field_150319_E) continue;
                score += 4;
            }
        }
        if (score >= BotaniaConfig.TNT_DUPE_HEURISTIC) {
            tnt.func_184216_O().add("CheatyDupe");
        }
    }

    static Block getBlockOrMovingBlock(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPiston) {
            return ((TileEntityPiston)tile).func_174927_b().func_177230_c();
        }
        return world.func_180495_p(pos).func_177230_c();
    }
}

