/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.botaniatweaks.modules.botania.tile.TileCompressedTinyPotato;
import quaternary.botaniatweaks.modules.shared.helper.MathUtil;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockCompressedTinyPotato
extends Block
implements ILexiconable {
    public final int compressionLevel;
    final int potatoCount;
    final AxisAlignedBB aabb;
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177706_a((String)"facing", EnumFacing.class, (Enum[])EnumFacing.field_176754_o);

    public static double compressionLevelToRadius(int compressionLevel) {
        return MathUtil.rangeRemap(compressionLevel, 0.0, 8.0, 0.125, 0.5);
    }

    public BlockCompressedTinyPotato(int compressionLevel) {
        super(Material.field_151580_n);
        if (compressionLevel <= 0 || compressionLevel >= 9) {
            throw new IllegalArgumentException("Only 8 potato compression levels are allowed");
        }
        this.compressionLevel = compressionLevel;
        this.potatoCount = (int)Math.pow(9.0, compressionLevel);
        double radius = BlockCompressedTinyPotato.compressionLevelToRadius(compressionLevel);
        double height = radius * 3.0;
        this.aabb = new AxisAlignedBB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, height, 0.5 + radius);
        this.func_149711_c(0.25f * (float)(1 + compressionLevel));
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String nicePotatoCount = String.format("%,d", this.potatoCount);
        tooltip.add(I18n.func_135052_a((String)"botania_tweaks.compressedpotato.tooltip", (Object[])new Object[]{nicePotatoCount}));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSimpleInventory) {
            InventoryHelper.dropInventory((TileSimpleInventory)((TileSimpleInventory)tile), (World)world, (IBlockState)state, (BlockPos)pos);
            super.func_180663_b(world, pos, state);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCompressedTinyPotato) {
            ((TileCompressedTinyPotato)tile).interact(player, hand, player.func_184586_b(hand), side);
            for (int i = 0; i < this.compressionLevel + 1; ++i) {
                double x = (double)pos.func_177958_n() + MathUtil.rangeRemap(world.field_73012_v.nextDouble(), 0.0, 1.0, this.aabb.field_72340_a, this.aabb.field_72336_d);
                double y = (double)pos.func_177956_o() + this.aabb.field_72337_e + 0.1875;
                double z = (double)pos.func_177952_p() + MathUtil.rangeRemap(world.field_73012_v.nextDouble(), 0.0, 1.0, this.aabb.field_72339_c, this.aabb.field_72334_f);
                world.func_175688_a(EnumParticleTypes.HEART, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        if (stack.func_82837_s() && (te = world.func_175625_s(pos)) instanceof TileCompressedTinyPotato) {
            ((TileCompressedTinyPotato)te).name = stack.func_82833_r();
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCompressedTinyPotato(this.compressionLevel);
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.aabb;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.compressionLevel != 8) {
            return BlockFaceShape.UNDEFINED;
        }
        return face == EnumFacing.UP ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return LexiconData.tinyPotato;
    }
}

