/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.Connection;
import vswe.superfactory.components.Point;
import vswe.superfactory.components.TextBoxLogic;
import vswe.superfactory.components.internal.ComponentType;
import vswe.superfactory.components.internal.ConnectionOption;
import vswe.superfactory.components.internal.ConnectionSet;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.IComponentNetworkReader;
import vswe.superfactory.network.packets.PacketHandler;
import vswe.superfactory.settings.Settings;
import vswe.superfactory.tiles.TileEntityManager;

public class FlowComponent
implements IComponentNetworkReader,
Comparable<FlowComponent> {
    private static final int ARROW_SIZE_H = 10;
    private static final int ARROW_SIZE_W = 9;
    private static final int ARROW_SRC_X = 0;
    private static final int ARROW_SRC_Y = 20;
    private static final int ARROW_X = -10;
    private static final int ARROW_Y = 5;
    private static final int COMPONENT_SIZE_H = 20;
    private static final int COMPONENT_SIZE_LARGE_H = 152;
    private static final int COMPONENT_SIZE_LARGE_W = 124;
    private static final int COMPONENT_SIZE_W = 64;
    private static final int COMPONENT_SRC_LARGE_X = 64;
    private static final int COMPONENT_SRC_X = 0;
    private static final int COMPONENT_SRC_Y = 0;
    private static final int CONNECTION_SIZE_H = 6;
    private static final int CONNECTION_SIZE_W = 7;
    private static final int CONNECTION_SRC_X = 0;
    private static final int CONNECTION_SRC_Y = 58;
    private static final int CONNECTION_SRC_Y_SIDE = 245;
    private static final int CURSOR_X = -1;
    private static final int CURSOR_Y = -4;
    private static final int CURSOR_Z = 5;
    private static final int DRAGGABLE_SIZE = 6;
    private static final int EDIT_SIZE = 9;
    private static final int EDIT_SIZE_SMALL = 7;
    private static final int EDIT_SRC_X = 32;
    private static final int EDIT_SRC_Y = 189;
    private static final int EDIT_X = 103;
    private static final int EDIT_X_SMALL = 105;
    private static final int EDIT_Y = 6;
    private static final int EDIT_Y_BOT = 11;
    private static final int EDIT_Y_TOP = 2;
    private static final int ERROR_SIZE_H = 10;
    private static final int ERROR_SIZE_W = 2;
    private static final int ERROR_SRC_X = 42;
    private static final int ERROR_SRC_Y = 212;
    private static final int ERROR_X = 2;
    private static final int ERROR_Y = 8;
    private static final int MAX_NODES = 15;
    private static final int MENU_ARROW_SIZE_H = 9;
    private static final int MENU_ARROW_SIZE_W = 9;
    private static final int MENU_ARROW_SRC_X = 0;
    private static final int MENU_ARROW_SRC_Y = 40;
    private static final int MENU_ARROW_X = 109;
    private static final int MENU_ARROW_Y = 2;
    private static final int MENU_ITEM_CAPACITY = 5;
    private static final int MENU_ITEM_SIZE_H = 13;
    private static final int MENU_ITEM_SIZE_W = 120;
    private static final int MENU_ITEM_SRC_X = 0;
    private static final int MENU_ITEM_SRC_Y = 152;
    private static final int MENU_ITEM_TEXT_X = 5;
    private static final int MENU_ITEM_TEXT_Y = 3;
    private static final int MENU_SIZE_H = 130;
    private static final int MENU_X = 2;
    private static final int MENU_Y = 20;
    private static final String NBT_CONNECTION = "Connection";
    private static final String NBT_CONNECTION_POS = "ConnectionPos";
    private static final String NBT_CONNECTION_TARGET_COMPONENT = "ConnectionComponent";
    private static final String NBT_CONNECTION_TARGET_CONNECTION = "ConnectionConnection";
    private static final String NBT_INTERVAL = "Interval";
    private static final String NBT_MENUS = "Menus";
    private static final String NBT_NAME = "Name";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_PARENT = "Parent";
    private static final String NBT_POS_X = "PosX";
    private static final String NBT_POS_Y = "PosY";
    private static final String NBT_TYPE = "Type";
    private static final int NODE_SIZE = 4;
    private static final int NODE_SRC_X = 120;
    private static final int NODE_SRC_Y = 152;
    private static final int TEXT_HEIGHT = 10;
    private static final int TEXT_MAX_LENGTH = Integer.MAX_VALUE;
    private static final int TEXT_SPACE = 135;
    private static final int TEXT_SPACE_SHORT = 65;
    private static final int TEXT_X = 7;
    private static final int TEXT_Y = 10;
    List<String> errors = new ArrayList<String>();
    private String cachedName;
    private String cachedShortName;
    private List<FlowComponent> childrenInputNodes;
    private List<FlowComponent> childrenOutputNodes;
    private ConnectionSet connectionSet;
    private Map<Integer, Connection> connections;
    private int currentInterval;
    private int id;
    private boolean isDragging;
    private boolean isEditing;
    private boolean isInventoryListDirty = true;
    private boolean isLarge;
    private boolean isLoading;
    private TileEntityManager manager;
    private List<ComponentMenu> menus;
    private int mouseDragX;
    private int mouseDragY;
    private int mouseStartX;
    private int mouseStartY;
    private String name;
    private int openMenuId;
    private int overrideX = -1;
    private int overrideY = -1;
    private FlowComponent parent;
    private int parentLoadId = -1;
    private int resetTimer;
    private TextBoxLogic textBox;
    private ComponentType type;
    private int x;
    private int y;

    public FlowComponent(TileEntityManager manager, int x, int y, ComponentType type) {
        this.x = x;
        this.y = y;
        this.connectionSet = type.getSets()[0];
        this.type = type;
        this.manager = manager;
        this.id = manager.getFlowItems().size();
        this.menus = new ArrayList<ComponentMenu>();
        for (Class<? extends ComponentMenu> componentMenuClass : type.getClasses()) {
            try {
                Constructor<? extends ComponentMenu> constructor = componentMenuClass.getConstructor(FlowComponent.class);
                ComponentMenu obj = constructor.newInstance(this);
                this.menus.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.openMenuId = -1;
        this.connections = new HashMap<Integer, Connection>();
        this.textBox = new TextBoxLogic(Integer.MAX_VALUE, 135);
        this.childrenInputNodes = new ArrayList<FlowComponent>();
        this.childrenOutputNodes = new ArrayList<FlowComponent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowComponent readFromNBT(TileEntityManager jam, NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        FlowComponent component = null;
        try {
            short x = nbtTagCompound.func_74765_d(NBT_POS_X);
            short y = nbtTagCompound.func_74765_d(NBT_POS_Y);
            byte typeId = nbtTagCompound.func_74771_c(NBT_TYPE);
            component = new FlowComponent(jam, x, y, ComponentType.getTypeFromId(typeId));
            component.isLoading = true;
            component.name = nbtTagCompound.func_74764_b(NBT_NAME) ? nbtTagCompound.func_74779_i(NBT_NAME) : null;
            if (nbtTagCompound.func_74764_b(NBT_PARENT)) {
                component.parentLoadId = nbtTagCompound.func_74765_d(NBT_PARENT);
            }
            NBTTagList connections = nbtTagCompound.func_150295_c(NBT_CONNECTION, 10);
            for (int i = 0; i < connections.func_74745_c(); ++i) {
                NBTTagCompound connectionTag = connections.func_150305_b(i);
                short componentId = version < 9 ? connectionTag.func_74771_c(NBT_CONNECTION_TARGET_COMPONENT) : connectionTag.func_74765_d(NBT_CONNECTION_TARGET_COMPONENT);
                Connection connection = new Connection(componentId, connectionTag.func_74771_c(NBT_CONNECTION_TARGET_CONNECTION));
                if (connectionTag.func_74764_b(NBT_NODES)) {
                    connection.getNodes().clear();
                    NBTTagList nodes = connectionTag.func_150295_c(NBT_NODES, 10);
                    for (int j = 0; j < nodes.func_74745_c(); ++j) {
                        NBTTagCompound nodeTag = nodes.func_150305_b(j);
                        connection.getNodes().add(new Point(nodeTag.func_74765_d(NBT_POS_X), nodeTag.func_74765_d(NBT_POS_Y)));
                    }
                }
                component.connections.put(Integer.valueOf(connectionTag.func_74771_c(NBT_CONNECTION_POS)), connection);
            }
            if (component.type == ComponentType.TRIGGER) {
                component.currentInterval = nbtTagCompound.func_74765_d(NBT_INTERVAL);
            }
            NBTTagList menuTagList = nbtTagCompound.func_150295_c(NBT_MENUS, 10);
            int menuId = 0;
            for (int i = 0; i < menuTagList.func_74745_c(); ++i) {
                NBTTagCompound menuTag = menuTagList.func_150305_b(i);
                if (component.type == ComponentType.TRIGGER && i == 1 && version < 1) {
                    ++menuId;
                }
                if (component.type == ComponentType.TRIGGER && i == 2 && version < 5) {
                    ++menuId;
                }
                if (component.type == ComponentType.TRIGGER && i == 0 && version < 6) {
                    ++menuId;
                }
                if (component.type == ComponentType.TRIGGER && i == 1 && version < 8) {
                    ++menuId;
                }
                if (component.type == ComponentType.TRIGGER && i == 4 && version < 8) {
                    ++menuId;
                }
                if (component.type == ComponentType.FLOW_CONTROL && i == 0 && version < 4) {
                    ++menuId;
                }
                if (component.type == ComponentType.CAMOUFLAGE && i == 1 && version < 10) {
                    menuId += 2;
                }
                if (component.type == ComponentType.AUTO_CRAFTING && i == 1 && version < 11) {
                    ++menuId;
                }
                component.menus.get(menuId).readFromNBT(menuTag, version, pickup);
                ++menuId;
            }
            FlowComponent flowComponent = component;
            return flowComponent;
        }
        finally {
            if (component != null) {
                component.isLoading = false;
            }
        }
    }

    public int getCurrentInterval() {
        return this.currentInterval;
    }

    public void setCurrentInterval(int currentInterval) {
        this.currentInterval = currentInterval;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void update(float partial) {
        if (this.resetTimer > 0) {
            if (this.resetTimer == 1) {
                this.x = this.mouseStartX;
                this.y = this.mouseStartY;
            }
            --this.resetTimer;
        }
        for (ComponentMenu menu : this.menus) {
            menu.update(partial);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY, int zLevel) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)zLevel);
        gui.drawTexture(this.x, this.y, this.isLarge ? 64 : 0, 0, this.getComponentWidth(), this.getComponentHeight());
        int internalX = mX - this.x;
        int internalY = mY - this.y;
        int srcArrowX = this.isLarge ? 1 : 0;
        int srcArrowY = this.inArrowBounds(internalX, internalY) ? 1 : 0;
        gui.drawTexture(this.x + this.getComponentWidth() + -10, this.y + 5, 0 + 9 * srcArrowX, 20 + 10 * srcArrowY, 9, 10);
        if (this.isLarge) {
            for (int i = 0; i < this.menus.size(); ++i) {
                ComponentMenu menu = this.menus.get(i);
                if (!menu.isVisible()) {
                    if (this.openMenuId != i) continue;
                    this.openMenuId = -1;
                    continue;
                }
                int itemX = this.getMenuAreaX();
                int itemY = this.y + this.getMenuItemY(i);
                gui.drawTexture(itemX, itemY, 0, 152, 120, 13);
                int srcItemArrowX = this.inMenuArrowBounds(i, internalX, internalY) ? 1 : 0;
                int srcItemArrowY = i == this.openMenuId ? 1 : 0;
                gui.drawTexture(itemX + 109, itemY + 2, 0 + 9 * srcItemArrowX, 40 + 9 * srcItemArrowY, 9, 9);
                gui.drawString(menu.getName(), this.x + 2 + 5, this.y + this.getMenuItemY(i) + 3, 0x404040);
                if (i != this.openMenuId) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)itemX, (float)this.getMenuAreaY(i), (float)0.0f);
                menu.draw(gui, mX - itemX, mY - this.getMenuAreaY(i));
                GlStateManager.func_179121_F();
            }
        }
        boolean hasConnection = false;
        int outputCount = 0;
        int inputCount = 0;
        int sideCount = 0;
        for (int i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connectedConnection;
            ConnectionOption connection = this.connectionSet.getConnections()[i];
            int[] location = this.getConnectionLocation(connection, inputCount, outputCount, sideCount);
            if (location == null) continue;
            if (connection.isInput()) {
                ++inputCount;
            } else if (connection.getType() == ConnectionOption.ConnectionType.OUTPUT) {
                ++outputCount;
            } else {
                ++sideCount;
            }
            int connectionWidth = location[3];
            int connectionHeight = location[4];
            int srcConnectionX = CollisionHelper.inBounds(location[0], location[1], connectionWidth, connectionHeight, mX, mY) ? 1 : 0;
            Connection current = this.manager.getCurrentlyConnecting();
            if (current != null && current.getComponentId() == this.id && current.getConnectionId() == i) {
                gui.drawLine(location[0] + connectionWidth / 2, location[1] + connectionHeight / 2, this.overrideX != -1 ? this.overrideX : mX, this.overrideY != -1 ? this.overrideY : mY);
            }
            if ((connectedConnection = this.connections.get(i)) != null) {
                hasConnection = true;
                if (this.id < connectedConnection.getComponentId() && connectedConnection.getComponentId() < this.manager.getFlowItems().size()) {
                    int[] otherLocation = this.manager.getFlowItems().get(connectedConnection.getComponentId()).getConnectionLocationFromId(connectedConnection.getConnectionId());
                    if (otherLocation == null) continue;
                    int startX = location[0] + connectionWidth / 2;
                    int startY = location[1] + connectionHeight / 2;
                    int endX = otherLocation[0] + connectionWidth / 2;
                    int endY = otherLocation[1] + connectionHeight / 2;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-zLevel));
                    List<Point> nodes = connectedConnection.getNodes();
                    for (int j = 0; j <= nodes.size(); ++j) {
                        int y2;
                        int x2;
                        int y1;
                        int x1;
                        if (j == 0) {
                            x1 = startX;
                            y1 = startY;
                        } else {
                            x1 = nodes.get(j - 1).getX();
                            y1 = nodes.get(j - 1).getY();
                        }
                        if (j == nodes.size()) {
                            x2 = endX;
                            y2 = endY;
                        } else {
                            x2 = nodes.get(j).getX();
                            y2 = nodes.get(j).getY();
                        }
                        gui.drawLine(x1, y1, x2, y2);
                    }
                    for (Point node : nodes) {
                        int x = node.getX() - 2;
                        int y = node.getY() - 2;
                        int srcXNode = connectedConnection.getSelectedNode() == null && CollisionHelper.inBounds(x, y, 4, 4, mX, mY) ? 1 : 0;
                        gui.drawTexture(x, y, 120 + srcXNode * 4, 152, 4, 4);
                    }
                    GlStateManager.func_179121_F();
                }
            }
            gui.drawTexture(location[0], location[1], 0 + srcConnectionX * connectionWidth, location[2], connectionWidth, connectionHeight);
        }
        this.errors.clear();
        if (hasConnection || this.getConnectionSet().getConnections().length == 0) {
            for (ComponentMenu menu : this.menus) {
                if (!menu.isVisible()) continue;
                menu.addErrors(this.errors);
            }
        }
        if (!this.errors.isEmpty()) {
            int srcErrorY = CollisionHelper.inBounds(this.x + 2, this.y + 8, 2, 10, mX, mY) ? 1 : 0;
            gui.drawTexture(this.x + 2, this.y + 8, 42, 212 + srcErrorY * 10, 2, 10);
        }
        if (!this.isEditing || this.isLarge) {
            String name = this.getName();
            if (!this.isLarge) {
                name = this.getShortName(gui, name);
            }
            gui.drawString(name, this.x + 7, this.y + 10, 0.7f, this.isEditing ? 0x707020 : 0x404040);
        }
        if (this.isEditing) {
            gui.drawString(this.getShortName(gui, this.getName()), this.x + 7, this.y + 10, 0.7f, 0x207020);
        }
        if (this.name != null && Settings.isCommandTypes() && !GuiScreen.func_146271_m()) {
            gui.drawCenteredString(this.getType().getName(), this.x + 6, this.y + 3, 0.7f, this.getComponentWidth() - 6 - 9, 0x707070);
        }
        if (this.isLarge) {
            if (this.isEditing) {
                gui.drawCursor(this.x + 7 + (int)((float)(this.textBox.getCursorPosition(gui) + -1) * 0.7f), this.y + 10 + -2, 5, 0.7f, -1);
                int i = 0;
                while (i < 2) {
                    int buttonX = this.x + 105;
                    int buttonY = this.y + (i == 0 ? 2 : 11);
                    int srcXButton = CollisionHelper.inBounds(buttonX, buttonY, 7, 7, mX, mY) ? 1 : 0;
                    int srcYButton = i++;
                    gui.drawTexture(buttonX, buttonY, 32 + srcXButton * 7, 198 + 7 * srcYButton, 7, 7);
                }
            } else {
                int buttonX = this.x + 103;
                int buttonY = this.y + 6;
                int srcXButton = CollisionHelper.inBounds(buttonX, buttonY, 9, 9, mX, mY) ? 1 : 0;
                gui.drawTexture(buttonX, buttonY, 32 + srcXButton * 9, 189, 9, 9);
            }
        }
        GlStateManager.func_179121_F();
    }

    private String getShortName(GuiManager gui, String name) {
        if (!name.equals(this.cachedName)) {
            this.cachedShortName = "";
            for (char c : name.toCharArray()) {
                if (gui.getStringWidth(this.cachedShortName + c) > 65) break;
                this.cachedShortName = this.cachedShortName + c;
            }
        }
        this.cachedName = name;
        return this.cachedShortName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return this.textBox.getText() == null ? (this.name == null || GuiScreen.func_146271_m() ? this.getType().getName() : this.name) : this.textBox.getText();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        if (this.isLarge) {
            for (int i = 0; i < this.menus.size(); ++i) {
                ComponentMenu menu = this.menus.get(i);
                if (!menu.isVisible() || i != this.openMenuId) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.getMenuAreaX(), (float)this.getMenuAreaY(i), (float)0.0f);
                menu.drawMouseOver(gui, mX - this.getMenuAreaX(), mY - this.getMenuAreaY(i));
                GlStateManager.func_179121_F();
            }
        }
        int outputCount = 0;
        int inputCount = 0;
        int sideCount = 0;
        for (ConnectionOption connection : this.connectionSet.getConnections()) {
            int[] location = this.getConnectionLocation(connection, inputCount, outputCount, sideCount);
            if (location == null) continue;
            if (connection.isInput()) {
                ++inputCount;
            } else if (connection.getType() == ConnectionOption.ConnectionType.OUTPUT) {
                ++outputCount;
            } else {
                ++sideCount;
            }
            if (!CollisionHelper.inBounds(location[0], location[1], 7, 6, mX, mY)) continue;
            gui.drawMouseOver(connection.getName(this, (connection.isInput() ? inputCount : outputCount) - 1), mX, mY);
        }
        if (!this.errors.isEmpty() && CollisionHelper.inBounds(this.x + 2, this.y + 8, 2, 10, mX, mY)) {
            String str = "";
            for (int i = 0; i < this.errors.size(); ++i) {
                if (i != 0) {
                    str = str + "\n\n";
                }
                str = str + this.errors.get(i);
            }
            gui.drawMouseOver(str, mX, mY);
        }
    }

    private int[] getConnectionLocation(ConnectionOption connection, int inputCount, int outputCount, int sideCount) {
        int targetY;
        int srcConnectionY;
        int totalCount;
        int currentCount;
        int id = inputCount + outputCount + sideCount;
        if (!connection.isInput()) {
            id -= Math.min(this.connectionSet.getInputCount(), this.childrenInputNodes.size());
        }
        if (!connection.isValid(this, id)) {
            return null;
        }
        if (connection.getType() == ConnectionOption.ConnectionType.SIDE) {
            int targetY2 = this.y + (int)((double)this.getComponentHeight() * (((double)sideCount + 0.5) / (double)this.connectionSet.getSideCount()));
            int targetX = this.x + this.getComponentWidth();
            return new int[]{targetX, targetY2 -= 3, 245, 6, 7};
        }
        if (connection.isInput()) {
            currentCount = inputCount;
            totalCount = this.connectionSet.getInputCount();
            if (this.getConnectionSet() == ConnectionSet.DYNAMIC) {
                totalCount = Math.min(totalCount, this.childrenInputNodes.size());
            }
            srcConnectionY = 1;
            targetY = this.y - 6;
        } else {
            currentCount = outputCount;
            totalCount = this.connectionSet.getOutputCount();
            if (this.getConnectionSet() == ConnectionSet.DYNAMIC) {
                totalCount = Math.min(totalCount, this.childrenOutputNodes.size());
            }
            srcConnectionY = 0;
            targetY = this.y + this.getComponentHeight();
        }
        int targetX = this.x + (int)((double)this.getComponentWidth() * (((double)currentCount + 0.5) / (double)totalCount));
        return new int[]{targetX -= 3, targetY, 58 + srcConnectionY * 6, 7, 6};
    }

    public ConnectionSet getConnectionSet() {
        return this.connectionSet;
    }

    public void setConnectionSet(ConnectionSet connectionSet) {
        if (this.connections != null && this.connectionSet != null && !this.isLoading) {
            Connection connection;
            int i;
            int oldLength = this.connectionSet.getConnections().length;
            int newLength = connectionSet.getConnections().length;
            for (i = 0; i < Math.min(oldLength, newLength); ++i) {
                connection = this.connections.get(i);
                if (connection == null || this.connectionSet.getConnections()[i].isInput() == connectionSet.getConnections()[i].isInput()) continue;
                this.removeConnection(i);
            }
            for (i = newLength; i < oldLength; ++i) {
                connection = this.connections.get(i);
                if (connection == null) continue;
                this.removeConnection(i);
            }
        }
        this.connectionSet = connectionSet;
    }

    public void removeConnection(int id) {
        Connection connection = this.connections.get(id);
        this.addConnection(id, null);
        if (connection.getComponentId() >= 0 && connection.getComponentId() < this.getManager().getFlowItems().size()) {
            this.manager.getFlowItems().get(connection.getComponentId()).addConnection(connection.getConnectionId(), null);
        }
    }

    private void addConnection(int id, Connection connection) {
        if (this.getManager().func_145831_w() != null && this.getManager().func_145831_w().field_72995_K) {
            DataWriter dw = PacketHandler.getWriterForServerComponentPacket(this, null);
            if (connection != null) {
                this.writeConnectionData(dw, id, true, connection.getComponentId(), connection.getConnectionId());
            } else {
                this.writeConnectionData(dw, id, false, 0, 0);
            }
            PacketHandler.sendDataToServer(dw);
        }
        this.connections.put(id, connection);
    }

    public TileEntityManager getManager() {
        return this.manager;
    }

    private void writeConnectionData(DataWriter dw, int i, boolean target, int targetComponent, int targetConnection) {
        dw.writeBoolean(false);
        dw.writeData(i, DataBitHelper.CONNECTION_ID);
        dw.writeBoolean(true);
        dw.writeBoolean(target);
        if (target) {
            dw.writeComponentId(this.getManager(), targetComponent);
            dw.writeData(targetConnection, DataBitHelper.CONNECTION_ID);
        }
    }

    public int getComponentWidth() {
        return this.isLarge ? 124 : 64;
    }

    public int getComponentHeight() {
        return this.isLarge ? 152 : 20;
    }

    private int getMenuAreaX() {
        return this.x + 2;
    }

    private int getMenuAreaY(int i) {
        return this.y + this.getMenuItemY(i) + 13;
    }

    private int getMenuItemY(int id) {
        int ret = 20;
        for (int i = 0; i < id; ++i) {
            if (!this.menus.get(i).isVisible()) continue;
            ret += 12;
            if (this.openMenuId != i) continue;
            ret += FlowComponent.getMenuOpenSize() - 1;
        }
        return ret;
    }

    public static int getMenuOpenSize() {
        return 70;
    }

    public boolean onClick(int mX, int mY, int button) {
        if (CollisionHelper.inBounds(this.x, this.y, this.getComponentWidth(), this.getComponentHeight(), mX, mY)) {
            int internalX = mX - this.x;
            int internalY = mY - this.y;
            if (internalX <= 6 && internalY <= 6) {
                this.mouseStartX = this.mouseDragX = mX;
                this.mouseStartY = this.mouseDragY = mY;
                this.isDragging = true;
            } else if (this.isLarge && !this.isEditing && CollisionHelper.inBounds(103, 6, 9, 9, internalX, internalY)) {
                this.isEditing = true;
                this.textBox.setTextAndCursor(this.getName());
            } else if (this.isLarge && this.isEditing && CollisionHelper.inBounds(105, 2, 7, 7, internalX, internalY)) {
                this.isEditing = false;
                this.name = this.textBox.getText();
                if (this.name.equals("")) {
                    this.name = null;
                }
                this.sendNameToServer();
                this.textBox.setText(null);
            } else if (this.isLarge && this.isEditing && CollisionHelper.inBounds(105, 11, 7, 7, internalX, internalY)) {
                this.isEditing = false;
                this.textBox.setText(null);
            } else if (this.isLarge && this.isEditing && CollisionHelper.inBounds(7, 10, 135, 10, internalX, internalY)) {
                if (button == 1) {
                    this.textBox.setTextAndCursor("");
                }
            } else if (this.inArrowBounds(internalX, internalY) || Settings.isLargeOpenHitBox() && internalY < 20) {
                if (!this.isLarge && this.type == ComponentType.GROUP && Settings.isQuickGroupOpen() && !GuiScreen.func_146272_n()) {
                    this.manager.setSelectedComponent(this);
                } else {
                    this.isLarge = !this.isLarge;
                }
            } else if (this.isLarge) {
                for (int i = 0; i < this.menus.size(); ++i) {
                    ComponentMenu menu = this.menus.get(i);
                    if (!menu.isVisible()) continue;
                    if (this.inMenuArrowBounds(i, internalX, internalY) || Settings.isLargeOpenHitBoxMenu() && internalY >= this.getMenuItemY(i) && internalY <= this.getMenuItemY(i) + 13) {
                        this.openMenuId = this.openMenuId == i ? -1 : i;
                        return true;
                    }
                    if (i != this.openMenuId) continue;
                    menu.onClick(mX - this.getMenuAreaX(), mY - this.getMenuAreaY(i), button);
                }
            }
            return true;
        }
        int outputCount = 0;
        int inputCount = 0;
        int sideCount = 0;
        for (int i = 0; i < this.connectionSet.getConnections().length; ++i) {
            ConnectionOption connection = this.connectionSet.getConnections()[i];
            int[] location = this.getConnectionLocation(connection, inputCount, outputCount, sideCount);
            if (location == null) continue;
            if (connection.isInput()) {
                ++inputCount;
            } else if (connection.getType() == ConnectionOption.ConnectionType.OUTPUT) {
                ++outputCount;
            } else {
                ++sideCount;
            }
            if (CollisionHelper.inBounds(location[0], location[1], 7, 6, mX, mY)) {
                Connection current = this.manager.getCurrentlyConnecting();
                if (button == 1 && current == null) {
                    Connection selected = this.connections.get(i);
                    if (selected != null) {
                        int connectionId = i;
                        boolean reversed = false;
                        FlowComponent component = this;
                        if (selected.getComponentId() < this.id) {
                            connectionId = selected.getConnectionId();
                            component = this.manager.getFlowItems().get(selected.getComponentId());
                            selected = component.getConnection(selected.getConnectionId());
                            reversed = true;
                        }
                        if (selected.getNodes().size() < 15 && selected.getSelectedNode() == null) {
                            int id = reversed ? selected.getNodes().size() : 0;
                            selected.addAndSelectNode(mX, mY, id);
                            component.sendConnectionNode(connectionId, id, false, true, mX, mY);
                        }
                    }
                } else if (current == null) {
                    if (this.connections.get(i) != null) {
                        this.removeConnection(i);
                    }
                    this.manager.setCurrentlyConnecting(new Connection(this.id, i));
                } else if (current.getComponentId() == this.id && current.getConnectionId() == i) {
                    this.manager.setCurrentlyConnecting(null);
                } else if (current.getComponentId() != this.id) {
                    FlowComponent connectTo = this.manager.getFlowItems().get(current.getComponentId());
                    if (connectTo.connectionSet.getConnections().length <= current.getConnectionId() || current.getConnectionId() < 0) {
                        return true;
                    }
                    ConnectionOption connectToOption = connectTo.connectionSet.getConnections()[current.getConnectionId()];
                    if (connectToOption.isInput() != connection.isInput()) {
                        if (this.checkForLoops(i, current)) {
                            return true;
                        }
                        if (this.connections.get(i) != null) {
                            this.removeConnection(i);
                        }
                        Connection thisConnection = new Connection(this.id, i);
                        connectTo.addConnection(current.getConnectionId(), thisConnection);
                        this.addConnection(i, this.manager.getCurrentlyConnecting());
                        this.manager.setCurrentlyConnecting(null);
                    }
                }
                return true;
            }
            Connection selected = this.connections.get(i);
            if (selected == null) continue;
            List<Point> nodes = selected.getNodes();
            for (int j = 0; j < nodes.size(); ++j) {
                int y;
                Point node = nodes.get(j);
                int x = node.getX() - 2;
                if (!CollisionHelper.inBounds(x, y = node.getY() - 2, 4, 4, mX, mY)) continue;
                if (button == 0) {
                    selected.setSelectedNode(node);
                } else if (button == 1) {
                    if (GuiScreen.func_146272_n()) {
                        this.sendConnectionNode(i, j, true, false, 0, 0);
                    } else if (selected.getNodes().size() < 15 && selected.getSelectedNode() == null) {
                        selected.addAndSelectNode(mX, mY, j + 1);
                        this.sendConnectionNode(i, j + 1, false, true, mX, mY);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkForLoops(int connectionId, Connection connection) {
        return this.checkForLoops(new ArrayList<Integer>(), this, connectionId, connection);
    }

    private boolean checkForLoops(List<Integer> usedComponents, FlowComponent currentComponent, int connectionId, Connection connection) {
        if (usedComponents.contains(currentComponent.getId())) {
            return true;
        }
        usedComponents.add(currentComponent.getId());
        for (int i = 0; i < currentComponent.connectionSet.getConnections().length; ++i) {
            ArrayList<Integer> usedComponentsCopy;
            if (currentComponent.connectionSet.getConnections()[i].isInput()) continue;
            Connection c = null;
            if (connectionId == i && currentComponent.getId() == this.id) {
                c = connection;
            } else if (connection.getComponentId() == currentComponent.getId() && connection.getConnectionId() == i) {
                c = new Connection(this.getId(), connectionId);
            } else {
                c = currentComponent.connections.get(i);
                if (c != null && c.getComponentId() == this.id && c.getConnectionId() == connectionId) {
                    c = null;
                }
            }
            if (c == null || c.getComponentId() < 0 || c.getComponentId() >= this.manager.getFlowItems().size() || !this.checkForLoops(usedComponentsCopy = new ArrayList<Integer>(usedComponents), this.manager.getFlowItems().get(c.getComponentId()), connectionId, connection)) continue;
            return true;
        }
        return false;
    }

    public void removeAllConnections() {
        for (int i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connection = this.connections.get(i);
            if (connection == null) continue;
            this.removeConnection(i);
        }
    }

    public void onDrag(int mX, int mY) {
        int i;
        this.followMouse(mX, mY);
        for (i = 0; i < this.menus.size(); ++i) {
            ComponentMenu menu = this.menus.get(i);
            menu.onDrag(mX - this.getMenuAreaX(), mY - this.getMenuAreaY(i), i == this.openMenuId);
        }
        for (i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connection = this.connections.get(i);
            if (connection == null) continue;
            connection.update(mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void followMouse(int mX, int mY) {
        if (this.isDragging) {
            this.x += mX - this.mouseDragX;
            this.y += mY - this.mouseDragY;
            if (GuiScreen.func_146272_n()) {
                this.adjustToGrid();
                this.mouseDragX = this.x;
                this.mouseDragY = this.y;
            } else {
                this.mouseDragX = mX;
                this.mouseDragY = mY;
            }
        }
    }

    private void adjustToGrid() {
        this.x = this.x / 10 * 10;
        this.y = this.y / 10 * 10;
    }

    public void onRelease(int mX, int mY, int button) {
        int i;
        this.followMouse(mX, mY);
        if (this.isDragging) {
            this.writeLocationData();
        }
        for (i = 0; i < this.menus.size(); ++i) {
            ComponentMenu menu = this.menus.get(i);
            menu.onRelease(mX - this.getMenuAreaX(), mY - this.getMenuAreaY(i), this.isLarge && i == this.openMenuId);
        }
        for (i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connection = this.connections.get(i);
            if (connection == null) continue;
            for (int j = 0; j < connection.getNodes().size(); ++j) {
                Point node = connection.getNodes().get(j);
                if (!node.equals(connection.getSelectedNode())) continue;
                connection.update(mX, mY);
                this.sendConnectionNode(i, j, false, false, node.getX(), node.getY());
                connection.setSelectedNode(null);
                return;
            }
        }
    }

    private void writeLocationData() {
        DataWriter dw = PacketHandler.getWriterForServerComponentPacket(this, null);
        this.writeLocationData(dw);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeLocationData(DataWriter dw) {
        dw.writeBoolean(true);
        dw.writeBoolean(true);
        dw.writeBoolean(true);
        dw.writeData(this.x, DataBitHelper.FLOW_CONTROL_X);
        dw.writeData(this.y, DataBitHelper.FLOW_CONTROL_Y);
    }

    private void sendConnectionNode(int connectionId, int nodeId, boolean deleted, boolean created, int x, int y) {
        DataWriter dw = PacketHandler.getWriterForServerComponentPacket(this, null);
        this.writeConnectionNode(dw, -1, connectionId, nodeId, deleted, created, x, y);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeConnectionNode(DataWriter dw, int length, int connectionId, int nodeId, boolean deleted, boolean created, int x, int y) {
        dw.writeBoolean(false);
        dw.writeData(connectionId, DataBitHelper.CONNECTION_ID);
        dw.writeBoolean(false);
        dw.writeData(nodeId, DataBitHelper.NODE_ID);
        if (length != -1) {
            dw.writeData(length, DataBitHelper.NODE_ID);
        }
        dw.writeBoolean(deleted);
        if (!deleted) {
            dw.writeBoolean(created);
            dw.writeData(x, DataBitHelper.FLOW_CONTROL_X);
            dw.writeData(y, DataBitHelper.FLOW_CONTROL_Y);
        }
    }

    public void postRelease() {
        this.isDragging = false;
    }

    public void adjustEverythingToGridRaw() {
    }

    public void adjustEverythingToGridFine() {
    }

    public int[] getConnectionLocationFromId(int id) {
        int outputCount = 0;
        int inputCount = 0;
        int sideCount = 0;
        for (int i = 0; i < this.connectionSet.getConnections().length; ++i) {
            ConnectionOption connection = this.connectionSet.getConnections()[i];
            int[] location = this.getConnectionLocation(connection, inputCount, outputCount, sideCount);
            if (location == null) continue;
            if (id == i) {
                return location;
            }
            if (connection.isInput()) {
                ++inputCount;
                continue;
            }
            if (connection.getType() == ConnectionOption.ConnectionType.OUTPUT) {
                ++outputCount;
                continue;
            }
            ++sideCount;
        }
        return null;
    }

    private boolean inArrowBounds(int internalX, int internalY) {
        return CollisionHelper.inBounds(this.getComponentWidth() + -10, 5, 9, 10, internalX, internalY);
    }

    private boolean inMenuArrowBounds(int i, int internalX, int internalY) {
        return CollisionHelper.inBounds(111, this.getMenuItemY(i) + 2, 9, 9, internalX, internalY);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.isLarge && this.isEditing) {
            this.textBox.onKeyStroke(gui, c, k);
            return true;
        }
        if (this.isLarge && this.openMenuId != -1) {
            return this.menus.get(this.openMenuId).onKeyStroke(gui, c, k);
        }
        return false;
    }

    public ComponentType getType() {
        return this.type;
    }

    public List<ComponentMenu> getMenus() {
        return this.menus;
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        if (dr.readBoolean()) {
            if (dr.readBoolean()) {
                if (dr.readBoolean()) {
                    this.x = dr.readData(DataBitHelper.FLOW_CONTROL_X);
                    this.y = dr.readData(DataBitHelper.FLOW_CONTROL_Y);
                } else if (dr.readBoolean()) {
                    this.setParent(this.getManager().getFlowItems().get(dr.readComponentId()));
                } else {
                    this.setParent(null);
                }
            } else {
                this.name = dr.readString(DataBitHelper.NAME_LENGTH);
            }
        } else {
            int connectionId = dr.readData(DataBitHelper.CONNECTION_ID);
            if (dr.readBoolean()) {
                Connection connection;
                if (dr.readBoolean()) {
                    int targetComponentId = dr.readComponentId();
                    int targetConnectionId = dr.readData(DataBitHelper.CONNECTION_ID);
                    connection = new Connection(targetComponentId, targetConnectionId);
                } else {
                    connection = null;
                }
                this.connections.put(connectionId, connection);
            } else if (this.connections.get(connectionId) != null) {
                Connection connection = this.connections.get(connectionId);
                int id = dr.readData(DataBitHelper.NODE_ID);
                int length = -1;
                if (this.manager.func_145831_w().field_72995_K) {
                    length = dr.readData(DataBitHelper.NODE_ID);
                }
                boolean deleted = dr.readBoolean();
                boolean created = false;
                if (!deleted) {
                    created = dr.readBoolean();
                }
                if (id >= 0 && (created && id == connection.getNodes().size() || id < connection.getNodes().size())) {
                    if (deleted) {
                        connection.getNodes().remove(id);
                    } else {
                        Point node;
                        if (created) {
                            node = new Point();
                            if (!(connection.getNodes().size() >= 15 || this.manager.func_145831_w().field_72995_K && length <= connection.getNodes().size())) {
                                connection.getNodes().add(id, node);
                            }
                        } else {
                            node = connection.getNodes().get(id);
                        }
                        node.setX(dr.readData(DataBitHelper.FLOW_CONTROL_X));
                        node.setY(dr.readData(DataBitHelper.FLOW_CONTROL_Y));
                    }
                }
            }
        }
    }

    public FlowComponent copy() {
        int i;
        FlowComponent copy = new FlowComponent(this.manager, this.x, this.y, this.type);
        copy.id = this.id;
        copy.name = this.name;
        for (i = 0; i < this.menus.size(); ++i) {
            ComponentMenu menu = this.menus.get(i);
            copy.menus.get(i).copyFrom(menu);
        }
        for (i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connection = this.connections.get(i);
            if (connection == null) continue;
            copy.connections.put(i, connection.copy());
        }
        return copy;
    }

    public void refreshData(ContainerManager container, FlowComponent newData) {
        int i;
        DataWriter dw;
        if (this.x != newData.x || this.y != newData.y) {
            this.x = newData.x;
            this.y = newData.y;
            dw = PacketHandler.getWriterForClientComponentPacket(container, this, null);
            this.writeLocationData(dw);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        if (this.parent == null != (newData.parent == null) || this.parent != null && this.parent.getId() != newData.parent.getId()) {
            if (newData.parent == null) {
                this.setParent(null);
            } else {
                this.setParent(this.getManager().getFlowItems().get(newData.parent.getId()));
            }
            dw = PacketHandler.getWriterForClientComponentPacket(container, this, null);
            this.writeParentData(dw);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        for (i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Point newNode;
            Point node;
            int j;
            boolean created;
            DataWriter dw2;
            if (newData.connections.get(i) == null && this.connections.get(i) != null) {
                this.connections.put(i, null);
                dw2 = PacketHandler.getWriterForClientComponentPacket(container, this, null);
                this.writeConnectionData(dw2, i, false, 0, 0);
                PacketHandler.sendDataToListeningClients(container, dw2);
            }
            if (newData.connections.get(i) != null && (this.connections.get(i) == null || newData.connections.get(i).getComponentId() != this.connections.get(i).getComponentId() || newData.connections.get(i).getConnectionId() != this.connections.get(i).getConnectionId())) {
                this.connections.put(i, newData.connections.get(i).copy());
                dw2 = PacketHandler.getWriterForClientComponentPacket(container, this, null);
                this.writeConnectionData(dw2, i, true, this.connections.get(i).getComponentId(), this.connections.get(i).getConnectionId());
                PacketHandler.sendDataToListeningClients(container, dw2);
            }
            Connection connection = this.connections.get(i);
            Connection newConnection = newData.connections.get(i);
            if (connection == null || newConnection == null) continue;
            boolean deleted = connection.getNodes().size() > newConnection.getNodes().size();
            boolean bl = created = connection.getNodes().size() < newConnection.getNodes().size();
            if (deleted) {
                boolean hasDeleted = false;
                for (j = 0; j < newConnection.getNodes().size(); ++j) {
                    node = connection.getNodes().get(j);
                    newNode = newConnection.getNodes().get(j);
                    if (node.getX() == newNode.getX() && node.getY() == newNode.getY()) continue;
                    this.sendClientConnectionNode(container, newConnection.getNodes().size(), i, j, true, false, 0, 0);
                    hasDeleted = true;
                    break;
                }
                if (!hasDeleted) {
                    this.sendClientConnectionNode(container, newConnection.getNodes().size(), i, newConnection.getNodes().size(), true, false, 0, 0);
                }
            } else {
                boolean updated = false;
                for (j = 0; j < connection.getNodes().size(); ++j) {
                    node = connection.getNodes().get(j);
                    newNode = newConnection.getNodes().get(j);
                    if (node.getX() == newNode.getX() && node.getY() == newNode.getY()) continue;
                    updated = true;
                    if (created) {
                        Point nextNode = newConnection.getNodes().get(j + 1);
                        if (node.getX() == nextNode.getX() && node.getY() == nextNode.getY()) {
                            this.sendClientConnectionNode(container, newConnection.getNodes().size(), i, j, false, true, newNode.getX(), newNode.getY());
                            break;
                        }
                    }
                    this.sendClientConnectionNode(container, newConnection.getNodes().size(), i, j, false, false, newNode.getX(), newNode.getY());
                    break;
                }
                if (!updated && created) {
                    int nodeId = connection.getNodes().size();
                    this.sendClientConnectionNode(container, newConnection.getNodes().size(), i, nodeId, false, true, newConnection.getNodes().get(nodeId).getX(), newConnection.getNodes().get(nodeId).getY());
                }
            }
            this.connections.put(i, newConnection.copy());
        }
        if (newData.name == null && this.name != null || newData.name != null && this.name == null || newData != null && this.name != null && !newData.name.equals(this.name)) {
            this.name = newData.name;
            this.sendNameToClient(container);
        }
        for (i = 0; i < this.menus.size(); ++i) {
            this.menus.get(i).refreshData(container, newData.menus.get(i));
        }
    }

    private void writeParentData(DataWriter dw) {
        dw.writeBoolean(true);
        dw.writeBoolean(true);
        dw.writeBoolean(false);
        if (this.parent != null) {
            dw.writeBoolean(true);
            dw.writeComponentId(this.getManager(), this.parent.getId());
        } else {
            dw.writeBoolean(false);
        }
    }

    private void sendClientConnectionNode(ContainerManager container, int length, int connectionId, int nodeId, boolean deleted, boolean created, int x, int y) {
        DataWriter dw = PacketHandler.getWriterForClientComponentPacket(container, this, null);
        this.writeConnectionNode(dw, length, connectionId, nodeId, deleted, created, x, y);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private void sendNameToClient(ContainerManager container) {
        DataWriter dw = PacketHandler.getWriterForClientComponentPacket(container, this, null);
        this.writeName(dw);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    private void writeName(DataWriter dw) {
        dw.writeBoolean(true);
        dw.writeBoolean(false);
        dw.writeString(this.name, DataBitHelper.NAME_LENGTH);
    }

    public Connection getConnection(int i) {
        return this.connections.get(i);
    }

    public boolean isBeingMoved() {
        return this.isDragging;
    }

    public void decreaseId() {
        --this.id;
    }

    public void updateConnectionIdsAtRemoval(int idToRemove) {
        for (int i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connection = this.connections.get(i);
            if (connection == null) continue;
            if (connection.getComponentId() == idToRemove) {
                this.connections.remove(i);
                continue;
            }
            if (connection.getComponentId() <= idToRemove) continue;
            connection.setComponentId(connection.getComponentId() - 1);
        }
        if (this.parent != null && this.parent.getId() == idToRemove) {
            this.setParent(null);
        }
    }

    private void sendNameToServer() {
        DataWriter dw = PacketHandler.getWriterForServerComponentPacket(this, null);
        this.writeName(dw);
        PacketHandler.sendDataToServer(dw);
    }

    public void linkParentAfterLoad() {
        if (this.parentLoadId != -1) {
            this.setParent(this.getManager().getFlowItems().get(this.parentLoadId));
        } else {
            this.setParent(null);
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74777_a(NBT_POS_X, (short)this.x);
        nbtTagCompound.func_74777_a(NBT_POS_Y, (short)this.y);
        nbtTagCompound.func_74774_a(NBT_TYPE, (byte)this.type.getId());
        if (this.name != null) {
            nbtTagCompound.func_74778_a(NBT_NAME, this.name);
        }
        if (this.parent != null) {
            nbtTagCompound.func_74777_a(NBT_PARENT, (short)this.parent.getId());
        }
        NBTTagList connections = new NBTTagList();
        for (int i = 0; i < this.connectionSet.getConnections().length; ++i) {
            Connection connection = this.connections.get(i);
            if (connection == null) continue;
            NBTTagCompound connectionTag = new NBTTagCompound();
            connectionTag.func_74774_a(NBT_CONNECTION_POS, (byte)i);
            connectionTag.func_74777_a(NBT_CONNECTION_TARGET_COMPONENT, (short)connection.getComponentId());
            connectionTag.func_74774_a(NBT_CONNECTION_TARGET_CONNECTION, (byte)connection.getConnectionId());
            NBTTagList nodes = new NBTTagList();
            for (Point point : connection.getNodes()) {
                NBTTagCompound nodeTag = new NBTTagCompound();
                nodeTag.func_74777_a(NBT_POS_X, (short)point.getX());
                nodeTag.func_74777_a(NBT_POS_Y, (short)point.getY());
                nodes.func_74742_a((NBTBase)nodeTag);
            }
            connectionTag.func_74782_a(NBT_NODES, (NBTBase)nodes);
            connections.func_74742_a((NBTBase)connectionTag);
        }
        nbtTagCompound.func_74782_a(NBT_CONNECTION, (NBTBase)connections);
        if (this.type == ComponentType.TRIGGER) {
            nbtTagCompound.func_74777_a(NBT_INTERVAL, (short)this.currentInterval);
        }
        NBTTagList menuTagList = new NBTTagList();
        for (int i = 0; i < this.menus.size(); ++i) {
            ComponentMenu menu = this.menus.get(i);
            NBTTagCompound menuTag = new NBTTagCompound();
            menu.writeToNBT(menuTag, pickup);
            menuTagList.func_74742_a((NBTBase)menuTag);
        }
        nbtTagCompound.func_74782_a(NBT_MENUS, (NBTBase)menuTagList);
    }

    public boolean isOpen() {
        return this.isLarge;
    }

    public void setOpen(boolean b) {
        this.isLarge = b;
        this.openMenuId = -1;
    }

    public void close() {
        this.isLarge = false;
    }

    public void setConnection(int i, Connection connection) {
        this.connections.put(i, connection);
    }

    public void clearConnections() {
        this.connections.clear();
    }

    public String getComponentName() {
        return this.name;
    }

    public void setComponentName(String name) {
        this.name = name;
    }

    public FlowComponent getParent() {
        return this.parent;
    }

    public void setParent(FlowComponent parent) {
        if (this.parent != null && (this.getConnectionSet() == ConnectionSet.INPUT_NODE || this.getConnectionSet() == ConnectionSet.OUTPUT_NODE)) {
            this.parent.childrenInputNodes.remove(this);
            this.parent.childrenOutputNodes.remove(this);
            Collections.sort(this.parent.childrenInputNodes);
            Collections.sort(this.parent.childrenOutputNodes);
        }
        this.parent = parent;
        if (this.parent != null) {
            if (this.getConnectionSet() == ConnectionSet.INPUT_NODE && !this.parent.childrenInputNodes.contains(this)) {
                this.parent.childrenInputNodes.add(this);
                Collections.sort(this.parent.childrenInputNodes);
            } else if (this.getConnectionSet() == ConnectionSet.OUTPUT_NODE && !this.parent.childrenOutputNodes.contains(this)) {
                this.parent.childrenOutputNodes.add(this);
                Collections.sort(this.parent.childrenOutputNodes);
            }
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowComponent component = (FlowComponent)o;
        return this.id == component.id;
    }

    public boolean isVisible() {
        return this.isVisible(this.getManager().getSelectedComponent());
    }

    public boolean isVisible(FlowComponent selectedComponent) {
        return selectedComponent == null && this.parent == null || this.parent != null && this.parent.equals(selectedComponent);
    }

    public List<FlowComponent> getChildrenOutputNodes() {
        return this.childrenOutputNodes;
    }

    public List<FlowComponent> getChildrenInputNodes() {
        return this.childrenInputNodes;
    }

    @Override
    public int compareTo(FlowComponent o) {
        return Integer.valueOf(this.id).compareTo(o.id);
    }

    public void resetPosition() {
        this.resetTimer = 20;
    }

    public void setParentLoadId(int i) {
        this.parentLoadId = i;
    }

    public boolean isInventoryListDirty() {
        return this.isInventoryListDirty;
    }

    public void setInventoryListDirty(boolean inventoryListDirty) {
        this.isInventoryListDirty = inventoryListDirty;
    }

    public void doScroll(int scroll) {
        if (this.isLarge && this.openMenuId != -1) {
            this.menus.get(this.openMenuId).doScroll(scroll);
        }
    }

    public void onGuiClosed() {
        for (ComponentMenu menu : this.menus) {
            menu.onGuiClosed();
        }
    }

    public void setNameEdited(boolean b) {
        this.isEditing = b;
        if (b) {
            this.textBox.setTextAndCursor("");
        } else {
            this.textBox.setText(null);
        }
    }

    public void refreshEditing(String name) {
        this.textBox.setTextAndCursor(name);
    }

    public boolean isNameBeingEdited() {
        return this.isEditing;
    }

    public int getOverrideY() {
        return this.overrideY;
    }

    public void setOverrideY(int overrideY) {
        this.overrideY = overrideY;
    }

    public int getOverrideX() {
        return this.overrideX;
    }

    public void setOverrideX(int overrideX) {
        this.overrideX = overrideX;
    }

    public Map<Integer, Connection> getConnections() {
        return this.connections;
    }

    public int getOpenMenuId() {
        return this.openMenuId;
    }

    public void setOpenMenuId(int openMenuId) {
        this.openMenuId = openMenuId;
    }
}

