/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.components.CheckBox;
import vswe.superfactory.components.CheckBoxList;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.components.ScrollController;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public abstract class ComponentMenuStuff
extends ComponentMenu {
    protected static final int EDIT_ITEM_X = 5;
    protected static final int EDIT_ITEM_Y = 5;
    protected static final int ITEM_SIZE = 16;
    protected static final int ITEM_SIZE_WITH_MARGIN = 20;
    protected static final int ITEM_X = 5;
    protected static final int RADIO_BUTTON_X_LEFT = 5;
    protected static final int RADIO_BUTTON_X_RIGHT = 65;
    protected static final int RADIO_BUTTON_Y = 5;
    private static final int BACK_SIZE_H = 9;
    private static final int BACK_SIZE_W = 9;
    private static final int BACK_SRC_X = 46;
    private static final int BACK_SRC_Y = 52;
    private static final int BACK_X = 108;
    private static final int BACK_Y = 57;
    private static final int DELETE_SIZE_H = 11;
    private static final int DELETE_SIZE_W = 32;
    private static final int DELETE_SRC_X = 0;
    private static final int DELETE_SRC_Y = 130;
    private static final int DELETE_TEXT_Y = 3;
    private static final int DELETE_X = 85;
    private static final int DELETE_Y = 3;
    private static final String NBT_RADIO_SELECTION = "FirstSelected";
    private static final String NBT_SETTINGS = "Settings";
    private static final String NBT_SETTING_ID = "Id";
    private static final String NBT_SETTING_USE_SIZE = "SizeLimit";
    private static final int SETTING_SRC_X = 0;
    private static final int SETTING_SRC_Y = 189;
    protected CheckBoxList checkBoxes;
    protected TextBoxNumberList numberTextBoxes;
    protected RadioButtonList radioButtons;
    protected ScrollController scrollControllerSearch;
    protected ScrollController<Setting> scrollControllerSelected;
    protected Setting selectedSetting;
    protected List<Setting> settings = new ArrayList<Setting>();
    private boolean editSetting;
    private List<Setting> externalSettings = new ArrayList<Setting>();

    public ComponentMenuStuff(FlowComponent parent, Class<? extends Setting> settingClass) {
        super(parent);
        for (int i = 0; i < this.getSettingCount(); ++i) {
            try {
                Setting obj;
                Constructor<? extends Setting> constructor = settingClass.getConstructor(Integer.TYPE);
                Setting setting = obj = constructor.newInstance(i);
                this.settings.add(setting);
                this.externalSettings.add(setting);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Failed to create setting");
            }
        }
        this.numberTextBoxes = new TextBoxNumberList();
        this.radioButtons = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                DataWriter dw = ComponentMenuStuff.this.getWriterForServerComponentPacket();
                dw.writeBoolean(false);
                ComponentMenuStuff.this.writeRadioButtonRefreshState(dw, selectedOption == 0);
                PacketHandler.sendDataToServer(dw);
            }
        };
        this.initRadioButtons();
        this.checkBoxes = new CheckBoxList();
        if (this.settings.get(0).isAmountSpecific()) {
            this.checkBoxes.addCheckBox(new CheckBox(Localization.SPECIFY_AMOUNT, 5, 25){

                @Override
                public boolean getValue() {
                    return ComponentMenuStuff.this.selectedSetting.isLimitedByAmount();
                }

                @Override
                public void setValue(boolean val) {
                    ComponentMenuStuff.this.selectedSetting.setLimitedByAmount(val);
                }

                @Override
                public void onUpdate() {
                    ComponentMenuStuff.this.writeServerData(DataTypeHeader.USE_AMOUNT);
                }
            });
        }
        final ComponentMenuStuff self = this;
        this.scrollControllerSearch = new ScrollController(true){

            protected List getSearchResults(String search, boolean all) {
                return self.updateSearch(search, all);
            }

            protected void onClick(Object o, int mX, int mY, int button) {
                ComponentMenuStuff.this.selectedSetting.setContent(o);
                ComponentMenuStuff.this.writeServerData(DataTypeHeader.SET_ITEM);
                ComponentMenuStuff.this.selectedSetting = null;
                this.updateScrolling();
            }

            protected void draw(GuiManager gui, Object o, int x, int y, boolean hover) {
                ComponentMenuStuff.this.drawResultObject(gui, o, x, y);
            }

            protected void drawMouseOver(GuiManager gui, Object o, int mX, int mY) {
                if (o != null) {
                    gui.drawMouseOver(ComponentMenuStuff.this.getResultObjectMouseOver(o), mX, mY);
                }
            }
        };
        this.scrollControllerSelected = new ScrollController<Setting>(false){

            @Override
            protected List<Setting> getSearchResults(String search, boolean all) {
                return ComponentMenuStuff.this.settings;
            }

            @Override
            protected void onClick(Setting setting, int mX, int mY, int button) {
                ComponentMenuStuff.this.selectedSetting = setting;
                ComponentMenuStuff.this.editSetting = button == 1 && ComponentMenuStuff.this.doAllowEdit();
                if (ComponentMenuStuff.this.editSetting && !ComponentMenuStuff.this.selectedSetting.isValid()) {
                    ComponentMenuStuff.this.selectedSetting = null;
                    ComponentMenuStuff.this.editSetting = false;
                } else {
                    if (ComponentMenuStuff.this.editSetting) {
                        ComponentMenuStuff.this.updateTextBoxes();
                    }
                    this.updateScrolling();
                }
            }

            @Override
            protected void draw(GuiManager gui, Setting setting, int x, int y, boolean hover) {
                int srcSettingX = setting.isValid() ? 0 : 1;
                int srcSettingY = hover ? 1 : 0;
                gui.drawTexture(x, y, 0 + srcSettingX * 16, 189 + srcSettingY * 16, 16, 16);
                if (setting.isValid()) {
                    ComponentMenuStuff.this.drawSettingObject(gui, setting, x, y);
                }
            }

            @Override
            protected void drawMouseOver(GuiManager gui, Setting setting, int mX, int mY) {
                if (setting.isValid()) {
                    gui.drawMouseOver(ComponentMenuStuff.this.getSettingObjectMouseOver(setting), mX, mY);
                }
            }
        };
    }

    protected void initRadioButtons() {
        this.radioButtons.add(new RadioButton(5, 5, Localization.WHITE_LIST));
        this.radioButtons.add(new RadioButton(65, 5, Localization.BLACK_LIST));
    }

    protected int getSettingCount() {
        return 30;
    }

    protected boolean doAllowEdit() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawResultObject(GuiManager var1, Object var2, int var3, int var4);

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawSettingObject(GuiManager var1, Setting var2, int var3, int var4);

    @SideOnly(value=Side.CLIENT)
    protected abstract List<String> getResultObjectMouseOver(Object var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract List<String> getSettingObjectMouseOver(Setting var1);

    protected abstract void updateTextBoxes();

    protected void writeRadioButtonRefreshState(DataWriter dw, boolean value) {
        dw.writeBoolean(value);
    }

    protected void writeServerData(DataTypeHeader header) {
        this.writeServerData(header, this.selectedSetting);
    }

    protected void writeServerData(DataTypeHeader header, Setting setting) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, header, setting);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, DataTypeHeader header, Setting setting) {
        dw.writeBoolean(true);
        dw.writeData(setting.getId(), DataBitHelper.MENU_ITEM_SETTING_ID);
        dw.writeData(header.id, DataBitHelper.MENU_ITEM_TYPE_HEADER);
        switch (header) {
            case CLEAR: {
                break;
            }
            case USE_AMOUNT: {
                if (!setting.isAmountSpecific()) break;
                dw.writeBoolean(setting.isLimitedByAmount());
                break;
            }
            case AMOUNT: {
                if (!setting.isAmountSpecific()) break;
                dw.writeData(setting.getAmount(), this.getAmountBitLength());
                break;
            }
            default: {
                this.writeSpecificHeaderData(dw, header, setting);
            }
        }
        if (this.getParent().getManager().func_145831_w().field_72995_K) {
            this.onSettingContentChange();
        }
    }

    protected abstract DataBitHelper getAmountBitLength();

    protected abstract void writeSpecificHeaderData(DataWriter var1, DataTypeHeader var2, Setting var3);

    protected void onSettingContentChange() {
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract List updateSearch(String var1, boolean var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        if (this.isEditing()) {
            this.checkBoxes.draw(gui, mX, mY);
            this.drawSettingObject(gui, this.selectedSetting, 5, 5);
            this.numberTextBoxes.draw(gui, mX, mY);
            this.drawInfoMenuContent(gui, mX, mY);
            int srcDeleteY = this.inDeleteBounds(mX, mY) ? 1 : 0;
            gui.drawTexture(85, 3, 0, 130 + srcDeleteY * 11, 32, 11);
            gui.drawCenteredString(Localization.DELETE.toString(), 85, 6, 0.7f, 32, 0xBB4040);
        } else {
            if (!this.isSearching()) {
                this.radioButtons.draw(gui, mX, mY);
            }
            if (this.isListVisible()) {
                this.getScrollingList().draw(gui, mX, mY);
            }
        }
        if (this.selectedSetting != null) {
            int srcBackX = this.inBackBounds(mX, mY) ? 1 : 0;
            gui.drawTexture(108, 57, 46 + srcBackX * 9, 52, 9, 9);
        }
    }

    protected boolean isListVisible() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawInfoMenuContent(GuiManager var1, int var2, int var3);

    private boolean inBackBounds(int mX, int mY) {
        return CollisionHelper.inBounds(108, 57, 9, 9, mX, mY);
    }

    private boolean inDeleteBounds(int mX, int mY) {
        return CollisionHelper.inBounds(85, 3, 32, 11, mX, mY);
    }

    private ScrollController getScrollingList() {
        return this.isSearching() ? this.scrollControllerSearch : this.scrollControllerSelected;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        if (this.isEditing()) {
            if (CollisionHelper.inBounds(5, 5, 16, 16, mX, mY)) {
                this.scrollControllerSelected.drawMouseOver(gui, this.selectedSetting, mX, mY);
            } else if (this.inDeleteBounds(mX, mY)) {
                gui.drawMouseOver(Localization.DELETE_ITEM_SELECTION.toString(), mX, mY);
            }
        } else if (this.isListVisible()) {
            this.getScrollingList().drawMouseOver(gui, mX, mY);
        }
        if (this.selectedSetting != null && this.inBackBounds(mX, mY)) {
            gui.drawMouseOver(this.isEditing() ? Localization.GO_BACK.toString() : Localization.CANCEL.toString(), mX, mY);
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        if (this.isEditing()) {
            this.checkBoxes.onClick(mX, mY);
            this.numberTextBoxes.onClick(mX, mY, button);
            if (this.inDeleteBounds(mX, mY)) {
                this.selectedSetting.delete();
                this.writeServerData(DataTypeHeader.CLEAR);
                this.selectedSetting = null;
                this.getScrollingList().updateScrolling();
            }
        } else {
            if (!this.isSearching()) {
                this.radioButtons.onClick(mX, mY, button);
            }
            if (this.isListVisible()) {
                this.getScrollingList().onClick(mX, mY, button);
            }
        }
        if (this.selectedSetting != null && this.inBackBounds(mX, mY)) {
            this.selectedSetting = null;
            this.getScrollingList().updateScrolling();
        }
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
        this.getScrollingList().onRelease(mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        return this.isSearching() && this.getScrollingList().onKeyStroke(gui, c, k) || this.isEditing() && this.numberTextBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.isFirstRadioButtonSelected());
        for (Setting setting : this.settings) {
            dw.writeBoolean(setting.isValid());
            if (!setting.isValid()) continue;
            setting.writeData(dw);
            if (!setting.isAmountSpecific()) continue;
            dw.writeBoolean(setting.isLimitedByAmount());
            if (!setting.isLimitedByAmount()) continue;
            dw.writeData(setting.getAmount(), this.getAmountBitLength());
        }
    }

    @Override
    public void readData(DataReader dr) {
        this.setFirstRadioButtonSelected(dr.readBoolean());
        for (Setting setting : this.settings) {
            if (!dr.readBoolean()) {
                setting.clear();
                continue;
            }
            setting.readData(dr);
            if (!setting.isAmountSpecific()) continue;
            setting.setLimitedByAmount(dr.readBoolean());
            if (setting.isLimitedByAmount()) {
                setting.setAmount(dr.readData(this.getAmountBitLength()));
                continue;
            }
            setting.setDefaultAmount();
        }
        this.onSettingContentChange();
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)menu;
        this.setFirstRadioButtonSelected(menuItem.isFirstRadioButtonSelected());
        for (int i = 0; i < this.settings.size(); ++i) {
            if (!menuItem.settings.get(i).isValid()) {
                this.settings.get(i).clear();
                continue;
            }
            this.settings.get(i).copyFrom(menuItem.settings.get(i));
            if (!this.settings.get(i).isAmountSpecific()) continue;
            this.settings.get(i).setLimitedByAmount(menuItem.settings.get(i).isLimitedByAmount());
            this.settings.get(i).setAmount(menuItem.settings.get(i).getAmount());
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        if (((ComponentMenuStuff)newData).isFirstRadioButtonSelected() != this.isFirstRadioButtonSelected()) {
            this.setFirstRadioButtonSelected(((ComponentMenuStuff)newData).isFirstRadioButtonSelected());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(false);
            this.writeRadioButtonRefreshState(dw, this.isFirstRadioButtonSelected());
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        for (int i = 0; i < this.settings.size(); ++i) {
            Setting setting = this.settings.get(i);
            Setting newSetting = ((ComponentMenuStuff)newData).settings.get(i);
            if (!newSetting.isValid() && setting.isValid()) {
                setting.clear();
                this.writeClientData(container, DataTypeHeader.CLEAR, setting);
            }
            if (!(!newSetting.isValid() || setting.isValid() && setting.isContentEqual(newSetting))) {
                setting.copyFrom(newSetting);
                this.writeClientData(container, DataTypeHeader.SET_ITEM, setting);
            }
            if (!setting.isAmountSpecific()) continue;
            if (newSetting.isLimitedByAmount() != setting.isLimitedByAmount()) {
                setting.setLimitedByAmount(newSetting.isLimitedByAmount());
                this.writeClientData(container, DataTypeHeader.USE_AMOUNT, setting);
            }
            if (!newSetting.isValid() || !setting.isValid() || newSetting.getAmount() == setting.getAmount()) continue;
            setting.setAmount(newSetting.getAmount());
            this.writeClientData(container, DataTypeHeader.AMOUNT, setting);
        }
    }

    protected void writeClientData(ContainerManager container, DataTypeHeader header, Setting setting) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, header, setting);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.setFirstRadioButtonSelected(nbtTagCompound.func_74767_n(NBT_RADIO_SELECTION));
        NBTTagList settingTagList = nbtTagCompound.func_150295_c(NBT_SETTINGS, 10);
        for (int i = 0; i < settingTagList.func_74745_c(); ++i) {
            NBTTagCompound settingTag = settingTagList.func_150305_b(i);
            Setting setting = this.settings.get(settingTag.func_74771_c(NBT_SETTING_ID));
            setting.load(settingTag);
            if (!setting.isAmountSpecific()) continue;
            setting.setLimitedByAmount(settingTag.func_74767_n(NBT_SETTING_USE_SIZE));
        }
        this.onSettingContentChange();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74757_a(NBT_RADIO_SELECTION, this.isFirstRadioButtonSelected());
        NBTTagList settingTagList = new NBTTagList();
        for (int i = 0; i < this.settings.size(); ++i) {
            Setting setting = this.settings.get(i);
            if (!setting.isValid()) continue;
            NBTTagCompound settingTag = new NBTTagCompound();
            settingTag.func_74774_a(NBT_SETTING_ID, (byte)setting.getId());
            setting.save(settingTag);
            if (setting.isAmountSpecific()) {
                settingTag.func_74757_a(NBT_SETTING_USE_SIZE, setting.isLimitedByAmount());
            }
            settingTagList.func_74742_a((NBTBase)settingTag);
        }
        nbtTagCompound.func_74782_a(NBT_SETTINGS, (NBTBase)settingTagList);
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.useWhiteList()) {
            for (Setting setting : this.settings) {
                if (!setting.isValid()) continue;
                return;
            }
            errors.add(Localization.EMPTY_WHITE_LIST_ERROR.toString());
        }
    }

    @Override
    public void update(float partial) {
        if (this.isSearching()) {
            this.scrollControllerSearch.update(partial);
        } else if (!this.isSearching() && !this.isEditing()) {
            this.scrollControllerSelected.update(partial);
        }
    }

    @Override
    public void doScroll(int scroll) {
        if (this.isSearching()) {
            this.scrollControllerSearch.doScroll(scroll);
        } else if (!this.isSearching() && !this.isEditing()) {
            this.scrollControllerSelected.doScroll(scroll);
        }
    }

    protected boolean isEditing() {
        return this.selectedSetting != null && this.editSetting;
    }

    protected boolean isSearching() {
        return this.selectedSetting != null && !this.editSetting;
    }

    public boolean useWhiteList() {
        return this.isFirstRadioButtonSelected();
    }

    protected boolean isFirstRadioButtonSelected() {
        return this.radioButtons.getSelectedOption() == 0;
    }

    protected void setFirstRadioButtonSelected(boolean value) {
        this.radioButtons.setSelectedOption(value ? 0 : 1);
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        boolean useSetting = dr.readBoolean();
        if (useSetting) {
            int settingId = dr.readData(DataBitHelper.MENU_ITEM_SETTING_ID);
            Setting setting = this.settings.get(settingId);
            int headerId = dr.readData(DataBitHelper.MENU_ITEM_TYPE_HEADER);
            DataTypeHeader header = this.getHeaderFromId(headerId);
            switch (header) {
                case CLEAR: {
                    setting.clear();
                    this.selectedSetting = null;
                    break;
                }
                case USE_AMOUNT: {
                    if (!setting.isAmountSpecific()) break;
                    setting.setLimitedByAmount(dr.readBoolean());
                    if (setting.isLimitedByAmount() || !setting.isValid()) break;
                    setting.setDefaultAmount();
                    break;
                }
                case AMOUNT: {
                    if (!setting.isAmountSpecific() || !setting.isValid()) break;
                    setting.setAmount(dr.readData(this.getAmountBitLength()));
                    if (!this.isEditing()) break;
                    this.updateTextBoxes();
                    break;
                }
                default: {
                    this.readSpecificHeaderData(dr, header, setting);
                }
            }
            this.onSettingContentChange();
        } else {
            this.readNonSettingData(dr);
        }
    }

    protected void readNonSettingData(DataReader dr) {
        this.setFirstRadioButtonSelected(dr.readBoolean());
    }

    protected abstract void readSpecificHeaderData(DataReader var1, DataTypeHeader var2, Setting var3);

    private DataTypeHeader getHeaderFromId(int id) {
        for (DataTypeHeader header : DataTypeHeader.values()) {
            if (id != header.id) continue;
            return header;
        }
        return null;
    }

    public List<Setting> getSettings() {
        return this.externalSettings;
    }

    public void setBlackList() {
        this.setFirstRadioButtonSelected(false);
    }

    protected static enum DataTypeHeader {
        CLEAR(0),
        SET_ITEM(1),
        USE_AMOUNT(2),
        USE_FUZZY(3),
        AMOUNT(4),
        META(5);

        private int id;

        private DataTypeHeader(int header) {
            this.id = header;
        }
    }
}

