/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.direct;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.util.Prep;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class DirectUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "direct";
    private static final Random random = new Random();
    @Nonnull
    public static final DirectUpgrade INSTANCE = new DirectUpgrade();
    @Nonnull
    public static final String HIT_BY_DIRECT = "eio:hbd";
    @Nonnull
    public static final String HIT_BY_DIRECT_FREE = "eio:hbdf";

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public DirectUpgrade() {
        super(UPGRADE_NAME, 0, "enderio.darksteel.upgrade.direct", Alloy.VIBRANT_ALLOY.getStackBlock(), DarkSteelConfig.directCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(EntityEquipmentSlot.MAINHAND) && (item.isBlockBreakingTool() || item.isWeapon()) && EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack) && !this.hasAnyUpgradeVariant(stack);
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void blockDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null || event.getHarvester() instanceof FakePlayerEIO) {
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = event.getHarvester().func_184586_b((EnumHand)NullHelper.notnullJ((Object)hand, (String)"EnumHand.values()"));
            if (!INSTANCE.hasAnyUpgradeVariant(stack) || EnergyUpgradeManager.getEnergyStored(stack) <= 0) continue;
            EnergyUpgradeManager.extractEnergy(stack, DirectUpgrade.doDirect(event) * (Integer)DarkSteelConfig.directEnergyCost.get(), false);
            return;
        }
    }

    @SubscribeEvent
    public static void attackEntityEvent(AttackEntityEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p.field_72995_K || event.getEntityPlayer() instanceof FakePlayerEIO) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (INSTANCE.hasAnyUpgradeVariant(stack) && EnergyUpgradeManager.getEnergyStored(stack) > 0) {
            event.getTarget().getEntityData().func_186854_a(HIT_BY_DIRECT, event.getEntityPlayer().func_110124_au());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingDropsEvent(LivingDropsEvent event) {
        EntityPlayer player;
        UUID uuid;
        EntityLivingBase mob = event.getEntityLiving();
        if (mob.getEntityData().func_186855_b(HIT_BY_DIRECT)) {
            ItemStack stack;
            EntityPlayer player2;
            UUID uuid2 = mob.getEntityData().func_186857_a(HIT_BY_DIRECT);
            if (uuid2 != null && (player2 = mob.field_70170_p.func_152378_a(uuid2)) != null && INSTANCE.hasAnyUpgradeVariant(stack = player2.func_184614_ca()) && EnergyUpgradeManager.getEnergyStored(stack) > 0) {
                EnergyUpgradeManager.extractEnergy(stack, DirectUpgrade.doDirect(event, player2) * (Integer)DarkSteelConfig.directEnergyCost.get(), false);
            }
        } else if (mob.getEntityData().func_186855_b(HIT_BY_DIRECT_FREE) && (uuid = mob.getEntityData().func_186857_a(HIT_BY_DIRECT_FREE)) != null && (player = mob.field_70170_p.func_152378_a(uuid)) != null) {
            DirectUpgrade.doDirect(event, player);
        }
    }

    private static Integer doDirect(LivingDropsEvent event, @Nonnull EntityPlayer player) {
        int count = 0;
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            EntityItem next = (EntityItem)NullHelper.notnullF(iterator.next(), (String)"null LivingDropsEvent in LivingDropsEvent");
            ItemStack remains = DirectUpgrade.fakeItemPickup(player, next.func_92059_d().func_77946_l());
            if (remains.func_190916_E() >= next.func_92059_d().func_190916_E()) continue;
            ++count;
            if (Prep.isValid(remains)) {
                next.func_92058_a(remains);
                continue;
            }
            next.func_70106_y();
            iterator.remove();
        }
        return count;
    }

    public static int doDirect(BlockEvent.HarvestDropsEvent event) {
        int count = 0;
        EntityPlayer player = (EntityPlayer)NullHelper.notnullF((Object)event.getHarvester(), (String)"BlockEvent.HarvestDropsEvent.getHarvester()");
        NNList remainsList = new NNList();
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack next = (ItemStack)NullHelper.notnullF(iterator.next(), (String)"null stack in HarvestDropsEvent");
            if (random.nextFloat() < event.getDropChance()) {
                ItemStack remains = DirectUpgrade.fakeItemPickup(player, next.func_77946_l());
                if (remains.func_190916_E() >= next.func_190916_E()) continue;
                ++count;
                iterator.remove();
                if (!Prep.isValid(remains)) continue;
                remainsList.add((Object)remains);
                continue;
            }
            iterator.remove();
        }
        event.getDrops().addAll(remainsList);
        event.setDropChance(1.0f);
        return count;
    }

    @Nonnull
    public static ItemStack fakeItemPickup(@Nonnull EntityPlayer player, @Nonnull ItemStack itemstack) {
        if (!player.field_70170_p.field_72995_K) {
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, itemstack);
            entityItem.func_70100_b_(player);
            if (entityItem.field_70128_L) {
                return Prep.getEmpty();
            }
            entityItem.func_70106_y();
            return entityItem.func_92059_d();
        }
        return itemstack;
    }
}

