/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enderio")
public class UpgradeRegistry {
    private static final Comparator<IDarkSteelUpgrade> darkSteelUpgradeComperator = new Comparator<IDarkSteelUpgrade>(){

        @Override
        public int compare(IDarkSteelUpgrade o1, IDarkSteelUpgrade o2) {
            return o1.getUnlocalizedName().compareTo(o2.getUnlocalizedName());
        }
    };
    private static IForgeRegistry<IDarkSteelUpgrade> REGISTRY = null;
    @Nonnull
    private static final NNList<IDarkSteelUpgrade> sortedList = new NNList();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("enderio", "upgrades")).setType(IDarkSteelUpgrade.class).setIDRange(0, 0x7FFFFFFE).add((owner, stage, id, obj, oldObj) -> sortedList.clear()).add((owner, stage) -> sortedList.clear()).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static NNList<IDarkSteelUpgrade> getUpgrades() {
        if (sortedList.isEmpty()) {
            NNList<IDarkSteelUpgrade> nNList = sortedList;
            synchronized (nNList) {
                sortedList.clear();
                sortedList.addAll(REGISTRY.getValuesCollection());
                sortedList.sort(darkSteelUpgradeComperator);
                Arrays.stream(((String)DarkSteelConfig.disabledUpgrades.get()).split("\\s*[,;]\\s*")).map(s -> s != null ? new ResourceLocation(s) : null).forEach(rl -> sortedList.remove((Object)UpgradeRegistry.getUpgrade(rl)));
            }
        }
        return sortedList;
    }

    @Nullable
    public static IDarkSteelUpgrade getUpgrade(ResourceLocation id) {
        return (IDarkSteelUpgrade)REGISTRY.getValue(id);
    }
}

