/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.config.RTConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class RTData {
    private static RTData data;
    public Map<String, Boolean> timeOfDayOverlay;
    public boolean stepup;
    public boolean fovChanges;

    public static RTData get() {
        if (data != null) {
            return data;
        }
        Path path = RTData.getPath();
        if (path.toFile().exists()) {
            try {
                data = (RTData)new Gson().fromJson(RTData.read(path), RTData.class);
            }
            catch (JsonSyntaxException ex) {
                RandomTweaks.LOGGER.error("Error in the RandomTweaks data JSON. The file will be replaced.", (Throwable)ex);
            }
        }
        if (data == null) {
            data = new RTData();
            RTData.data.timeOfDayOverlay = new HashMap<String, Boolean>();
            RTData.data.stepup = RTConfig.Client.stepupEnabledByDefault;
            RTData.data.fovChanges = RTConfig.Keybinds.fovChangesEnabledByDefault;
            RTData.save();
        } else if (RTData.data.timeOfDayOverlay == null) {
            RTData.data.timeOfDayOverlay = new HashMap<String, Boolean>();
            RTData.save();
        }
        return data;
    }

    public static void save() {
        RTData.get();
        try {
            Files.write(RTData.getPath(), Collections.singletonList(new Gson().toJson((Object)data)), new OpenOption[0]);
        }
        catch (IOException ex) {
            RandomTweaks.LOGGER.error("Error while saving RandomTweaks data", (Throwable)ex);
        }
    }

    public static Path getPath() {
        Path path = RTConfig.Client.storeDataInLocal ? Paths.get("local", "client", "rtdata.json") : Paths.get("config", "randomtweaks", "data.json");
        Path parent = path.getParent();
        try {
            if (parent != null) {
                if (Files.isRegularFile(parent, new LinkOption[0])) {
                    Files.delete(parent);
                }
                Files.createDirectories(parent, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            RandomTweaks.LOGGER.error("Failed to create parent: " + path, (Throwable)ex);
        }
        return path;
    }

    private static String read(Path path) {
        try {
            return StringUtils.join(Files.readAllLines(path), (String)System.lineSeparator());
        }
        catch (IOException ex) {
            RandomTweaks.LOGGER.error("Failed to read file: " + path, (Throwable)ex);
            return "{}";
        }
    }
}

