/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.client;

import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.config.RTConfig;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.lang.reflect.Field;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public final class CreativeTabHandler {
    public static final CreativeTabs SPAWN_EGGS = new CreativeTabs("spawnEggs"){

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            ItemStack stack = new ItemStack(Items.field_151063_bx);
            ItemMonsterPlacer.func_185078_a((ItemStack)stack, (ResourceLocation)new ResourceLocation("chicken"));
            return stack;
        }

        public void func_78018_a(NonNullList<ItemStack> itemList) {
            super.func_78018_a(itemList);
            if (!RTConfig.CreativeTabs.noAISpawnEggs) {
                return;
            }
            for (ResourceLocation id : EntityList.field_75627_a.keySet()) {
                ItemStack stack = new ItemStack(Items.field_151063_bx);
                ItemMonsterPlacer.func_185078_a((ItemStack)stack, (ResourceLocation)id);
                NBTTagCompound tag = stack.func_77978_p().func_74775_l("EntityTag");
                tag.func_74757_a("NoAI", true);
                itemList.add((Object)stack);
            }
        }
    };
    public static final Field TAB_PAGE = TRLUtils.findField(GuiContainerCreative.class, "tabPage");
    private static CreativeTabs originalBucketTab;
    private static boolean bucketSetBefore;
    private static CreativeTabs originalCommandBlockTab;
    private static boolean commandBlockSetBefore;
    private static CreativeTabs originalDragonEggTab;
    private static boolean dragonEggSetBefore;
    private static CreativeTabs originalSpawnEggsTab;

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        NBTTagCompound entityTag;
        ItemStack stack = event.getItemStack();
        if (stack == null || stack.func_77973_b() != Items.field_151063_bx) {
            return;
        }
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag != null && stackTag.func_74764_b("EntityTag") && (entityTag = stackTag.func_74775_l("EntityTag")).func_74767_n("NoAI")) {
            event.getToolTip().add(TRLUtils.localize("spawnEgg.noAI", new Object[0]));
        }
    }

    public static void initialize() {
        if (RTConfig.CreativeTabs.moveBucketCreativeTab) {
            originalBucketTab = Items.field_151133_ar.func_77640_w();
            bucketSetBefore = true;
            Items.field_151133_ar.func_77637_a(CreativeTabs.field_78040_i);
        } else if (bucketSetBefore) {
            Items.field_151133_ar.func_77637_a(originalBucketTab);
        }
        if (RTConfig.CreativeTabs.setCommandBlockCreativeTab) {
            originalCommandBlockTab = Blocks.field_150483_bI.func_149708_J();
            commandBlockSetBefore = true;
            Blocks.field_150483_bI.func_149647_a(CreativeTabs.field_78028_d);
            Blocks.field_185777_dd.func_149647_a(CreativeTabs.field_78028_d);
            Blocks.field_185776_dc.func_149647_a(CreativeTabs.field_78028_d);
        } else if (commandBlockSetBefore) {
            Blocks.field_150483_bI.func_149647_a(originalCommandBlockTab);
            Blocks.field_185777_dd.func_149647_a(originalCommandBlockTab);
            Blocks.field_185776_dc.func_149647_a(originalCommandBlockTab);
        }
        if (RTConfig.CreativeTabs.setDragonEggCreativeTab) {
            originalDragonEggTab = Blocks.field_150380_bt.func_149708_J();
            dragonEggSetBefore = true;
            Blocks.field_150380_bt.func_149647_a(CreativeTabs.field_78031_c);
        } else if (dragonEggSetBefore) {
            Blocks.field_150380_bt.func_149647_a(originalDragonEggTab);
        }
        CreativeTabHandler.registerSpawnEggsTab();
    }

    private static void registerSpawnEggsTab() {
        if (RTConfig.CreativeTabs.spawnEggsCreativeTab) {
            if (!ArrayUtils.contains((Object[])CreativeTabs.field_78032_a, (Object)SPAWN_EGGS)) {
                CreativeTabs.field_78032_a = (CreativeTabs[])ArrayUtils.add((Object[])CreativeTabs.field_78032_a, (Object)SPAWN_EGGS);
                CreativeTabHandler.SPAWN_EGGS.field_78033_n = CreativeTabs.field_78032_a.length - 1;
            }
            originalSpawnEggsTab = Items.field_151063_bx.func_77640_w();
            Items.field_151063_bx.func_77637_a(SPAWN_EGGS);
            return;
        }
        int index = ArrayUtils.indexOf((Object[])CreativeTabs.field_78032_a, (Object)SPAWN_EGGS);
        if (index != -1) {
            CreativeTabs.field_78032_a = (CreativeTabs[])ArrayUtils.remove((Object[])CreativeTabs.field_78032_a, (int)index);
            for (int i = index; i < CreativeTabs.field_78032_a.length; ++i) {
                CreativeTabs.field_78032_a[i].field_78033_n = i;
            }
            GuiContainerCreative.field_147058_w = CreativeTabs.field_78030_b.field_78033_n;
            try {
                TAB_PAGE.set(null, 0);
            }
            catch (Exception ex) {
                RandomTweaks.LOGGER.error("Error while disabling creative tab", (Throwable)ex);
            }
        }
        if (originalSpawnEggsTab != null) {
            Items.field_151063_bx.func_77637_a(originalSpawnEggsTab);
        }
    }
}

