/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.util;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import shadows.placebo.interfaces.ISpecialPlacement;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockCustomVine;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.enums.TheBigBookOfEnums;
import shadows.plants2.util.ControlledList;

public class PlantUtil {
    public static final List<BlockCustomVine> VINES = new ArrayList<BlockCustomVine>();
    public static final List<IBlockState> PLAINS = new ControlledList();
    public static final List<IBlockState> DESERT = new ControlledList();
    public static final List<IBlockState> CROP = new ControlledList();
    public static final List<IBlockState> DEFAULT = new ControlledList();
    public static final List<IBlockState> NETHER = new ControlledList();
    public static final List<IBlockState> END = new ControlledList();
    public static final Map<EnumPlantType, List<IBlockState>> TYPE_TO_STATES = new HashMap<EnumPlantType, List<IBlockState>>();
    static LanguageMap cancerino;

    public static boolean placeFlower(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if ((world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) && block.func_176196_c(world, pos)) {
            if (block instanceof ISpecialPlacement) {
                return ((ISpecialPlacement)block).placeStateAt(state, world, pos);
            }
            return world.func_180501_a(pos, state, 2);
        }
        return false;
    }

    public static void genFlowerPatch(World world, BlockPos pos, Random rand, IBlockState state) {
        int dist = PlantConfig.patchSize;
        for (int i = 0; i < PlantConfig.quantity; ++i) {
            int x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
            int z = pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
            for (int j = 0; j < PlantConfig.density; ++j) {
                int z1;
                int y1;
                int x1 = x + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
                BlockPos pos2 = new BlockPos(x1, y1 = world.func_175672_r(new BlockPos(x1, 0, z1 = z + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist))).func_177956_o(), z1);
                if (world.func_180495_p(pos2).func_185904_a() == Material.field_151586_h) continue;
                PlantUtil.placeFlower(world, pos2, state);
            }
        }
    }

    public static void genFlowerPatchForNether(World world, BlockPos pos, Random rand, IBlockState state) {
        int dist = PlantConfig.patchSize;
        for (int i = 0; i < PlantConfig.quantity; ++i) {
            int x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
            int z = pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
            for (int j = 0; j < PlantConfig.density; ++j) {
                int x1 = x + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
                int z1 = z + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
                int y1 = pos.func_177956_o();
                BlockPos pos2 = new BlockPos(x1, y1, z1);
                PlantUtil.placeFlower(world, pos2, state);
            }
        }
    }

    public static void genFlowerPatchForEnd(World world, BlockPos pos, Random rand, IBlockState state) {
        int dist = PlantConfig.patchSize;
        int x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
        int z = pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)(-dist), (int)dist);
        BlockPos pos2 = new BlockPos(x, pos.func_177956_o(), z);
        PlantUtil.placeFlower(world, pos2, state);
    }

    public static void genMegaPatch(World world, BlockPos pos, Random rand, IBlockState state) {
        for (int i = 0; i < 5; ++i) {
            int x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
            int z = pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
            for (int j = 0; j < 48; ++j) {
                int z1;
                int y1;
                int x1 = x + MathHelper.func_76136_a((Random)rand, (int)-6, (int)6);
                BlockPos pos2 = new BlockPos(x1, y1 = world.func_175672_r(new BlockPos(x1, 0, z1 = z + MathHelper.func_76136_a((Random)rand, (int)-6, (int)6))).func_177956_o(), z1);
                if (world.func_180495_p(pos2).func_185904_a() == Material.field_151586_h) continue;
                PlantUtil.placeFlower(world, pos2, state);
            }
        }
    }

    public static void genSmallFlowerPatchNearby(World world, BlockPos pos, Random rand, IBlockState state) {
        for (int i = 0; i < 2; ++i) {
            int x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
            int z = pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
            for (int j = 0; j < 3; ++j) {
                int z1;
                int y1;
                int x1 = x + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
                BlockPos pos2 = new BlockPos(x1, y1 = world.func_175672_r(new BlockPos(x1, 0, z1 = z + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2))).func_177956_o(), z1);
                if (world.func_180495_p(pos2).func_185904_a() == Material.field_151586_h) continue;
                PlantUtil.placeFlower(world, pos2, state);
            }
        }
    }

    public static BlockCustomVine getRandomVine(Random rand) {
        return VINES.get(rand.nextInt(VINES.size()));
    }

    public static void placeVine(World world, BlockCustomVine vine, BlockPos pos, EnumFacing facing) {
        if (!world.field_72995_K && vine.func_176198_a(world, pos.func_177972_a(facing), facing)) {
            world.func_175656_a(pos.func_177972_a(facing), vine.func_180642_a(world, pos.func_177972_a(facing), facing, 0.0f, 0.0f, 0.0f, 0, null));
        }
    }

    public static void mergeToDefaultLate() {
        DEFAULT.addAll(PLAINS);
        DEFAULT.addAll(CROP);
    }

    public static IBlockState getFlowerStateFor(EnumPlantType type, Random rand) {
        List<IBlockState> list = TYPE_TO_STATES.get(type);
        if (list.isEmpty()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return list.get(rand.nextInt(list.size()));
    }

    public static IBlockState getFlowerState(Random rand) {
        if (DEFAULT.isEmpty()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return DEFAULT.get(rand.nextInt(DEFAULT.size()));
    }

    public static IBlockState getDesertFlowerState(Random rand) {
        return PlantUtil.getFlowerStateFor(EnumPlantType.Desert, rand);
    }

    public static ItemStack getDyeForEnum(EnumDyeColor c) {
        return PlantUtil.getDyeForEnum(c, 1);
    }

    public static ItemStack getDyeForEnum(EnumDyeColor c, int size) {
        switch (c) {
            case BLUE: {
                return TheBigBookOfEnums.Generic.DYE_BLUE.get();
            }
            case WHITE: {
                return TheBigBookOfEnums.Generic.DYE_WHITE.get();
            }
            case BLACK: {
                return TheBigBookOfEnums.Generic.DYE_BLACK.get();
            }
            case BROWN: {
                return TheBigBookOfEnums.Generic.DYE_BROWN.get();
            }
        }
        return new ItemStack(Items.field_151100_aR, size, c.func_176767_b());
    }

    static void setupLangMap() {
        try {
            Method m = LanguageMap.class.getDeclaredMethod("inject", LanguageMap.class, InputStream.class);
            m.setAccessible(true);
            Object[] objectArray = new Object[2];
            cancerino = new LanguageMap();
            objectArray[0] = cancerino;
            objectArray[1] = Plants2.class.getResourceAsStream("/assets/plants2/lang/en_us.lang");
            m.invoke(null, objectArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Plants failed to access LanguageMap.inject.  Report this!");
        }
    }

    public static String sneakyConfigTranslate(String lang) {
        if (cancerino == null) {
            cancerino = new LanguageMap();
            PlantUtil.setupLangMap();
        }
        return cancerino.func_74805_b(lang);
    }

    static {
        TYPE_TO_STATES.put(EnumPlantType.Plains, PLAINS);
        TYPE_TO_STATES.put(EnumPlantType.Desert, DESERT);
        TYPE_TO_STATES.put(EnumPlantType.Crop, CROP);
        TYPE_TO_STATES.put(EnumPlantType.Nether, NETHER);
    }
}

