/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.placebo.item.ItemBase;
import shadows.placebo.registry.RegistryInformation;
import shadows.plants2.Plants2;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.util.PlantUtil;

public final class ItemPlantball
extends ItemBase
implements IHasRecipe {
    private static Map<IBlockState, Boolean> CACHE = new HashMap<IBlockState, Boolean>();

    public ItemPlantball() {
        super("plantball", (RegistryInformation)Plants2.INFO);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && player.func_175151_a(pos, facing, stack)) {
            IBlockState worldState = world.func_180495_p(pos);
            SoundType soundtype = SoundType.field_185850_c;
            IBlockState flower = PlantUtil.getFlowerState(world.field_73012_v);
            IBlockState desert = PlantUtil.getDesertFlowerState(world.field_73012_v);
            if (worldState.func_177230_c() == Blocks.field_150341_Y && facing.func_176740_k().func_176722_c()) {
                if (!world.field_72995_K) {
                    PlantUtil.placeVine(world, PlantUtil.getRandomVine(world.field_73012_v), pos, facing);
                }
                world.func_184133_a(player, pos.func_177984_a(), soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            if (desert.func_177230_c().func_176196_c(world, pos.func_177984_a())) {
                if (ItemPlantball.isBlacklisted(desert)) {
                    return EnumActionResult.FAIL;
                }
                if (!world.field_72995_K) {
                    ItemPlantball.genFlowers(world, pos, desert);
                    if (world.field_73012_v.nextInt(10) == 0) {
                        ItemPlantball.genFlowers(world, pos, desert);
                    }
                }
                world.func_184133_a(player, pos.func_177984_a(), soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            if (flower.func_177230_c().func_176196_c(world, pos.func_177984_a())) {
                if (ItemPlantball.isBlacklisted(flower)) {
                    return EnumActionResult.FAIL;
                }
                if (!world.field_72995_K) {
                    ItemPlantball.genFlowers(world, pos, flower);
                    if (world.field_73012_v.nextInt(10) == 0) {
                        ItemPlantball.genFlowers(world, pos, flower);
                    }
                }
                world.func_184133_a(player, pos.func_177984_a(), soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            if (worldState.func_177230_c() instanceof BlockBush && !worldState.func_177230_c().hasTileEntity(worldState)) {
                if (ItemPlantball.isBlacklisted(worldState)) {
                    return EnumActionResult.FAIL;
                }
                if (PlantConfig.allBushes || worldState.func_177230_c().getRegistryName().func_110624_b().equals("plants2") || worldState.func_177230_c().getRegistryName().func_110624_b().equals("minecraft")) {
                    if (!world.field_72995_K) {
                        ItemPlantball.genFlowers(world, pos, worldState);
                    }
                    world.func_184133_a(player, pos.func_177984_a(), soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    stack.func_190918_g(1);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    private static void genFlowers(World world, BlockPos pos, IBlockState state) {
        if (world.field_73011_w instanceof WorldProviderHell) {
            PlantUtil.genFlowerPatchForNether(world, pos, world.field_73012_v, state);
        } else {
            PlantUtil.genSmallFlowerPatchNearby(world, pos.func_177984_a(), world.field_73012_v, state);
        }
    }

    private static boolean isBlacklisted(IBlockState state) {
        if (CACHE.getOrDefault(state, false).booleanValue()) {
            return false;
        }
        if (PlantConfig.REGNAME_BL.contains((Object)state.func_177230_c().getRegistryName())) {
            return true;
        }
        if (PlantConfig.MODID_BL.contains((Object)state.func_177230_c().getRegistryName().func_110624_b())) {
            return true;
        }
        CACHE.put(state, true);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Use on grass for plants");
        tooltip.add("Use on moss stone for vines");
        tooltip.add("Use on a plant to copy it");
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        Plants2.HELPER.addShapeless(new ItemStack((Item)this, 5), new Object[]{"plant", "plant", "plant", "plant", "plant", "plant", "plant", "plant", "plant"});
        Plants2.HELPER.addShapeless(new ItemStack((Item)this, 2), new Object[]{"plant", "plant", "plant", "plant"});
    }
}

