/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;
import shadows.placebo.block.IEnumBlockAccess;
import shadows.placebo.interfaces.ITreeEnum;
import shadows.plants2.block.BlockEnumLeaves;
import shadows.plants2.data.PlantConfig;

public class EnumTreeGen<E extends ITreeEnum>
extends WorldGenTrees {
    protected final Block sapling;
    protected final IBlockState leaf;
    protected final IBlockState log;
    protected int minHeight = 0;

    public EnumTreeGen(boolean notify, int minHeight, IEnumBlockAccess<E> log, IEnumBlockAccess<E> leaf, E assign, boolean natural) {
        super(notify, minHeight, log.getStateFor(assign), leaf.getStateFor(assign), false);
        this.log = log.getStateFor(assign);
        this.leaf = leaf.getStateFor(assign);
        this.minHeight = minHeight;
        if (natural) {
            TreeGenerator.LIST.add(this);
        }
        assign.setTreeGen((WorldGenerator)this);
        this.sapling = ((BlockEnumLeaves)leaf).getSapling();
    }

    public EnumTreeGen(boolean notify, int minHeight, IEnumBlockAccess<E> log, IEnumBlockAccess<E> leaf, E assign) {
        this(notify, minHeight, log, leaf, assign, true);
    }

    public EnumTreeGen(E assign, boolean natural) {
        super(false, 0, null, null, false);
        TreeGenerator.LIST.add(this);
        assign.setTreeGen((WorldGenerator)this);
        this.sapling = Blocks.field_150329_H;
        this.leaf = null;
        this.log = null;
    }

    public EnumTreeGen(E assign) {
        this(assign, true);
    }

    public boolean canGen(World world, BlockPos pos) {
        if (PlantConfig.COMPUTED_BIOME_BL.contains((Object)world.func_180494_b(pos))) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        return world.func_180495_p(pos).func_185904_a() != Material.field_151586_h && (this.sapling.func_176196_c(world, pos) || state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150330_I));
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + this.minHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            if (this.sapling.func_176196_c(worldIn, position) && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                for (int i3 = position.func_177956_o() - 3 + i; i3 <= position.func_177956_o() + i; ++i3) {
                    int i4 = i3 - (position.func_177956_o() + i);
                    int j1 = 1 - i4 / 2;
                    for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                        int l1 = k1 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                            BlockPos blockpos;
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(k1, i3, i2))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos) && state.func_185904_a() != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, blockpos, this.leaf);
                        }
                    }
                }
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos upN = position.func_177981_b(j3);
                    state = worldIn.func_180495_p(upN);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN) && state.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j3), this.log);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static class TreeGenerator
    implements IWorldGenerator {
        public static final List<EnumTreeGen<?>> LIST = new ArrayList();

        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            if (!world.field_73011_w.func_191066_m()) {
                return;
            }
            if (PlantConfig.DIM_BL.contains((Object)world.field_73011_w.getDimension())) {
                return;
            }
            Random random2 = new Random(chunkZ ^ 8 + chunkX ^ 3 + random.nextInt(15060));
            if (random2.nextFloat() >= 0.16f) {
                return;
            }
            int posX = chunkX * 16;
            int posZ = chunkZ * 16;
            BlockPos genPos = new BlockPos(posX + MathHelper.func_76136_a((Random)random, (int)6, (int)10), 0, posZ + MathHelper.func_76136_a((Random)random, (int)6, (int)10));
            genPos = world.func_175672_r(genPos);
            EnumTreeGen<?> toGen = LIST.get(random.nextInt(LIST.size()));
            if (toGen.canGen(world, genPos)) {
                toGen.func_180709_b(world, random, genPos);
            }
        }
    }
}

