/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.client.IHasModel;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockEnumDoubleFlower;
import shadows.plants2.data.IColorProvider;
import shadows.plants2.data.PlantConstants;
import shadows.plants2.network.ParticleMessage;
import shadows.plants2.tile.TileBrewingCauldron;
import shadows.plants2.util.ColorToPotionUtil;

public class BlockBrewingCauldron
extends Block
implements IHasRecipe,
IHasModel {
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    public static final PropertyInteger LEVEL = BlockCauldron.field_176591_a;

    public BlockBrewingCauldron() {
        super(Material.field_151573_f, MapColor.field_151665_m);
        this.setRegistryName("brewing_cauldron");
        this.func_149663_c("plants2.brewing_cauldron");
        this.func_149647_a(PlantConstants.TAB);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        Plants2.INFO.getBlockList().add((Object)this);
        Plants2.INFO.getItemList().add((Object)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockBrewingCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockBrewingCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockBrewingCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockBrewingCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockBrewingCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity t = world.func_175625_s(pos);
        if (!(t instanceof TileBrewingCauldron)) {
            return false;
        }
        TileBrewingCauldron cauldron = (TileBrewingCauldron)t;
        if (stack.func_77973_b() == Items.field_151131_as) {
            if (cauldron.isBeingExtracted() || cauldron.hasMaxWater()) {
                return false;
            }
            if (!world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                }
                cauldron.setWaterLevel(cauldron.getWaterLevel() + 1);
            }
            world.func_184133_a(player, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            cauldron.func_70296_d();
            world.func_184138_a(pos, state, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(cauldron.getWaterLevel())), 3);
            return true;
        }
        if (ColorToPotionUtil.isDyeArrayValid(cauldron.getColors()) && stack.func_77973_b() == Items.field_151069_bo) {
            if (!world.field_72995_K) {
                ItemStack potion;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (cauldron.getPotion().func_190926_b()) {
                    cauldron.setPotion(ColorToPotionUtil.genPotionStack(cauldron));
                }
                if (!player.func_191521_c(potion = cauldron.getPotion())) {
                    Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)potion);
                }
                if (cauldron.getWaterLevel() - 1 == 0) {
                    cauldron.reset();
                } else {
                    cauldron.setWaterLevel(cauldron.getWaterLevel() - 1);
                }
            }
            world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            cauldron.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity t = world.func_175625_s(pos);
        if (!(t instanceof TileBrewingCauldron)) {
            return;
        }
        if (entity instanceof EntityItem) {
            TileBrewingCauldron cauldron = (TileBrewingCauldron)t;
            if (cauldron.isBeingExtracted() || !cauldron.hasMaxWater()) {
                return;
            }
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d();
            if (!cauldron.hasNetherWart() && stack.func_77973_b() == Items.field_151075_bm) {
                if (!cauldron.hasFirstWart()) {
                    cauldron.setFirstWart(true);
                    world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    stack.func_190918_g(1);
                    world.func_184138_a(pos, state, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(cauldron.getWaterLevel())), 3);
                    Plants2.NETWORK.sendToAllAround((IMessage)new ParticleMessage(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 150.0));
                    return;
                }
                cauldron.setSecondWart(true);
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                world.func_184138_a(pos, state, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(cauldron.getWaterLevel())), 3);
                Plants2.NETWORK.sendToAllAround((IMessage)new ParticleMessage(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 150.0));
                return;
            }
            if (cauldron.hasNetherWart() && !ColorToPotionUtil.isDyeArrayValid(cauldron.getColors())) {
                boolean doubled = false;
                EnumDyeColor color = null;
                if (stack.func_77973_b() instanceof IColorProvider) {
                    color = ((IColorProvider)stack.func_77973_b()).getColor(null);
                }
                if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IColorProvider) {
                    Block b = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                    IBlockState flower = b.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, stack.func_77960_j(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)), EnumHand.MAIN_HAND);
                    color = ((IColorProvider)b).getColor(flower);
                    doubled = b instanceof BlockEnumDoubleFlower;
                }
                if (color != null) {
                    for (int i = 0; i < 6 && !ColorToPotionUtil.isDyeArrayValid(cauldron.getColors()); ++i) {
                        if (cauldron.getColors()[i] != null) continue;
                        if (doubled) {
                            if (cauldron.getColors()[MathHelper.func_76125_a((int)(i + 1), (int)0, (int)5)] != null) break;
                            cauldron.setColor(i, color);
                            cauldron.setColor(MathHelper.func_76125_a((int)(i + 1), (int)0, (int)5), color);
                        } else {
                            cauldron.setColor(i, color);
                        }
                        world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        world.func_184138_a(pos, state, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(cauldron.getWaterLevel())), 3);
                        Plants2.NETWORK.sendToAllAround((IMessage)new ParticleMessage(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 150.0));
                        return;
                    }
                }
            } else if (cauldron.hasNetherWart() && ColorToPotionUtil.isDyeArrayValid(cauldron.getColors()) && cauldron.getPotionItem() == Items.field_151068_bn) {
                if (stack.func_77973_b() != Items.field_151016_H && stack.func_77973_b() != Items.field_185157_bK) {
                    return;
                }
                if (stack.func_77973_b() == Items.field_151016_H) {
                    cauldron.setGunpowder(true);
                } else if (stack.func_77973_b() == Items.field_185157_bK) {
                    cauldron.setDragBreath(true);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                world.func_184138_a(pos, state, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(cauldron.getWaterLevel())), 3);
                Plants2.NETWORK.sendToAllAround((IMessage)new ParticleMessage(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 150.0));
                return;
            }
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileBrewingCauldron) {
            state = state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(((TileBrewingCauldron)t).getWaterLevel()));
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBrewingCauldron();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels(ModelRegistryEvent e) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(Items.field_151066_bu.getRegistryName(), "inventory"));
        ModelLoader.setCustomStateMapper((Block)this, block -> {
            HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
            for (int i = 0; i < 4; ++i) {
                map.put(block.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(i)), new ModelResourceLocation("plants2:blocks", "type=cauldron_" + i));
            }
            return map;
        });
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        Plants2.HELPER.addShaped((IForgeRegistryEntry)this, 3, 3, new Object[]{"plant", "plant", "plant", Items.field_151065_br, Items.field_151066_bu, Items.field_151065_br, Blocks.field_150333_U, Blocks.field_150333_U, Blocks.field_150333_U});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        Plants2.PROXY.doCauldronParticles(state, world, pos, rand);
    }
}

