/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeSpiderNest
extends BasicUndergroundBiome {
    public static int floorCobwebChance;
    public static int ceilingCobwebChance;
    public static int caveSpiderSpawnerChance;
    public static int nestCobwebChance;
    public static int nestCobwebRange;

    public UndergroundBiomeSpiderNest() {
        super(Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P());
    }

    @Override
    public void fillCeiling(World world, BlockPos pos, IBlockState state) {
        super.fillCeiling(world, pos, state);
        this.placeCobweb(world, pos, EnumFacing.DOWN, ceilingCobwebChance);
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        super.fillFloor(world, pos, state);
        this.placeCobweb(world, pos, EnumFacing.UP, floorCobwebChance);
    }

    private void placeCobweb(World world, BlockPos pos, EnumFacing off, int chance) {
        if (chance > 0 && world.field_73012_v.nextInt(chance) == 0) {
            BlockPos placePos = off == null ? pos : pos.func_177972_a(off);
            world.func_175656_a(placePos, Blocks.field_150321_G.func_176223_P());
        }
    }

    @Override
    public boolean hasDungeon() {
        return true;
    }

    @Override
    public void spawnDungeon(WorldServer world, BlockPos pos, EnumFacing face) {
        TileEntityMobSpawner spawner;
        BlockPos spawnerPos = pos.func_177972_a(face);
        world.func_175656_a(spawnerPos, Blocks.field_150474_ac.func_176223_P());
        Class<EntitySpider> e = EntitySpider.class;
        if (caveSpiderSpawnerChance > 0 && world.field_73012_v.nextInt(caveSpiderSpawnerChance) == 0) {
            e = EntityCaveSpider.class;
        }
        if ((spawner = (TileEntityMobSpawner)world.func_175625_s(spawnerPos)) != null) {
            spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(e));
        }
        int range = 3;
        for (int x = -range; x < range + 1; ++x) {
            for (int y = -range; y < range + 1; ++y) {
                for (int z = -range; z < range + 1; ++z) {
                    BlockPos cobwebPos = spawnerPos.func_177982_a(x, y, z);
                    IBlockState stateAt = world.func_180495_p(cobwebPos);
                    if (!stateAt.func_177230_c().isAir(stateAt, (IBlockAccess)world, cobwebPos) && !stateAt.func_177230_c().func_176200_f((IBlockAccess)world, cobwebPos)) continue;
                    this.placeCobweb((World)world, cobwebPos, null, nestCobwebChance);
                }
            }
        }
    }

    @Override
    public void setupConfig(String category) {
        floorCobwebChance = ModuleLoader.config.getInt("Floor Cobweb Chance", category, 30, 0, Integer.MAX_VALUE, "The higher, the less floor cobwebs will spawn");
        ceilingCobwebChance = ModuleLoader.config.getInt("Ceiling Cobweb Chance", category, 10, 0, Integer.MAX_VALUE, "The higher, the less ceiling cobwebs will spawn");
        caveSpiderSpawnerChance = ModuleLoader.config.getInt("Cave Spider Spawner Chance", category, 4, 0, Integer.MAX_VALUE, "The (1 in X) chance for a spider spawner to be a cave spider spawner instead");
        nestCobwebChance = ModuleLoader.config.getInt("Nest Cobweb Chance", category, 2, 0, Integer.MAX_VALUE, "The higher, the less cobwebs will spawn in nests");
        nestCobwebRange = ModuleLoader.config.getInt("Nest Cobweb Range", category, 3, 0, Integer.MAX_VALUE, "The range for cobwebs to be spawned in spider nests");
    }
}

