/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.misc.feature.ColorRunes;
import vazkii.quark.world.block.BlockCrystal;
import vazkii.quark.world.world.CrystalCaveGenerator;

public class CrystalCaves
extends Feature {
    public static Block crystal;
    public static DimensionConfig dims;
    public static int crystalCaveRarity;

    @Override
    public void setupConfig() {
        crystalCaveRarity = this.loadPropInt("Crystal Cave Rarity", "Given this value as X, crystal caves will spawn on average 1 per X chunks", 150);
        dims = new DimensionConfig(this.configCategory);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        crystal = new BlockCrystal();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new CrystalCaveGenerator(dims), (int)1);
        ModIntegrationHandler.allowChiselAndBitsChiseling(crystal);
    }

    @Override
    public void postPreInit() {
        if (ModuleLoader.isFeatureEnabled(ColorRunes.class)) {
            this.addRuneRecipe(0, 0);
            this.addRuneRecipe(1, 14);
            this.addRuneRecipe(2, 1);
            this.addRuneRecipe(3, 4);
            this.addRuneRecipe(4, 5);
            this.addRuneRecipe(5, 3);
            this.addRuneRecipe(6, 11);
            this.addRuneRecipe(7, 2);
        }
    }

    private void addRuneRecipe(int crystalMeta, int runeMeta) {
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)ColorRunes.rune, (int)1, (int)runeMeta), (Object[])new Object[]{"CCC", "CSC", "CCC", Character.valueOf('C'), ProxyRegistry.newStack((Block)crystal, (int)1, (int)crystalMeta), Character.valueOf('S'), "stone"});
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

