/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.util.ClientUtils;
import fi.dy.masa.justenoughdimensions.util.world.VoidTeleport;
import fi.dy.masa.justenoughdimensions.util.world.WorldInfoUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import fi.dy.masa.justenoughdimensions.world.WorldProviderSurfaceJED;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderJED
extends WorldProviderSurface
implements IWorldProviderJED {
    protected JEDWorldProperties properties;
    protected boolean canRespawnHere;
    protected boolean isSurfaceWorld;
    protected boolean hasXZFog;
    protected double movementFactor;
    protected VoidTeleport.VoidTeleportData voidTeleport = null;
    protected VoidTeleport.VoidTeleportData skyTeleport = null;
    protected int teleportCounter;
    private boolean worldInfoSet;
    private boolean shouldSkipSpawnSearch;

    @Override
    public boolean getWorldInfoHasBeenSet() {
        return this.worldInfoSet;
    }

    @Override
    public boolean getShouldSkipSpawnSearch() {
        return this.shouldSkipSpawnSearch;
    }

    protected void func_76572_b() {
        super.func_76572_b();
        this.canRespawnHere = true;
        this.isSurfaceWorld = true;
        this.hasXZFog = false;
        this.movementFactor = 1.0;
        this.setBiomeProviderIfConfigured();
    }

    protected void setBiomeProviderIfConfigured() {
        DimensionConfigEntry entry = DimensionConfig.instance().getDimensionConfigFor(this.getDimension());
        if (entry != null) {
            if (entry.getBiome() != null) {
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(entry.getBiome()));
                if (biome != null) {
                    JustEnoughDimensions.logInfo("WorldProviderJED.setBiomeProviderIfConfigured(): Using BiomeProviderSingle with biome '{}' for dimension {}", entry.getBiome(), this.getDimension());
                    this.field_76578_c = new BiomeProviderSingle(biome);
                } else {
                    JustEnoughDimensions.logger.warn("Failed to find a biome by the name '{}' for dimension {}", (Object)entry.getBiome(), (Object)this.getDimension());
                }
            } else if (entry.getBiomeProvider() != null) {
                JustEnoughDimensions.logInfo("WorldProviderJED.setBiomeProviderIfConfigured(): Trying to create a BiomeProvider for dimension {} from the class name '{}'", this.getDimension(), entry.getBiomeProvider());
                BiomeProvider provider = WorldUtils.createBiomeProviderForName(entry.getBiomeProvider(), this.field_76579_a);
                if (provider != null) {
                    this.field_76578_c = provider;
                    JustEnoughDimensions.logInfo("WorldProviderJED.setBiomeProviderIfConfigured(): BiomeProvider created from the class name '{}'", entry.getBiomeProvider());
                } else {
                    JustEnoughDimensions.logger.warn("Failed to create a BiomeProvider from the class name '{}'", (Object)entry.getBiomeProvider());
                }
            } else if (entry.shouldUseNormalBiomes() && this.field_76578_c instanceof BiomeProviderSingle) {
                this.field_76578_c = new BiomeProvider(this.field_76579_a.func_72912_H());
            }
        }
    }

    public void setDimension(int dimension) {
        super.setDimension(dimension);
        this.properties = JEDWorldProperties.getOrCreateProperties(dimension);
        if (this.field_76579_a != null && !this.getWorldInfoHasBeenSet()) {
            BlockPos spawnOrig = this.getSpawnPoint();
            WorldInfoUtils.loadAndSetCustomWorldInfo(this.field_76579_a);
            this.shouldSkipSpawnSearch = !spawnOrig.equals((Object)this.getSpawnPoint());
            this.field_191067_f = this.properties.getHasSkyLight() != null ? this.properties.getHasSkyLight() : this.field_191067_f;
            this.worldInfoSet = true;
            this.skyTeleport = VoidTeleport.VoidTeleportData.fromJson(this.properties.getNestedObject("sky_teleport"), this.getDimension());
            this.voidTeleport = VoidTeleport.VoidTeleportData.fromJson(this.properties.getNestedObject("void_teleport"), this.getDimension());
            if (!this.field_76579_a.field_72995_K) {
                boolean allowHostiles = true;
                boolean allowPeaceful = true;
                if (!this.field_76579_a.func_72912_H().func_76093_s()) {
                    if (this.field_76579_a.func_73046_m().func_71264_H()) {
                        allowHostiles = this.field_76579_a.func_175659_aa() != EnumDifficulty.PEACEFUL;
                    } else {
                        allowHostiles = this.field_76579_a.func_73046_m().func_71193_K();
                        allowPeaceful = this.field_76579_a.func_73046_m().func_71268_U();
                    }
                }
                this.field_76579_a.func_72891_a(allowHostiles, allowPeaceful);
            }
        }
    }

    public DimensionType func_186058_p() {
        DimensionType type = null;
        try {
            type = DimensionManager.getProviderType((int)this.getDimension());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type != null ? type : super.func_186058_p();
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return this.properties.canSleepHere() != null ? this.properties.canSleepHere() : super.canSleepAt(player, pos);
    }

    public boolean func_76567_e() {
        return this.properties.canRespawnHere() != null ? this.properties.canRespawnHere() : this.canRespawnHere;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        if (this.properties.getRespawnDimension() != null) {
            return this.properties.getRespawnDimension();
        }
        return this.func_76567_e() ? this.getDimension() : 0;
    }

    public BlockPos func_177496_h() {
        return this.field_76579_a.func_175694_M();
    }

    public boolean func_186056_c(int x, int z) {
        return !this.func_186058_p().shouldLoadSpawn() || !this.field_76579_a.func_72916_c(x, z);
    }

    public void setAllowedSpawnTypes(boolean allowHostileIn, boolean allowPeacefulIn) {
        boolean allowHostile = this.field_76579_a.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL;
        boolean allowPeaceful = allowPeacefulIn;
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(this.getDimension());
        if (props != null) {
            Boolean hostiles = props.canSpawnHostiles();
            Boolean peaceful = props.canSpawnPeacefulMobs();
            if (hostiles != null) {
                allowHostile = hostiles;
            }
            if (peaceful != null) {
                allowPeaceful = peaceful;
            }
        }
        super.setAllowedSpawnTypes(allowHostile, allowPeaceful);
    }

    @Override
    public void setJEDProperties(JEDWorldProperties properties) {
        this.properties = properties;
        ClientUtils.setRenderersFrom((WorldProvider)this, this.properties.getFullJEDProperties());
    }

    public void func_186059_r() {
        super.func_186059_r();
        if (++this.teleportCounter >= this.properties.getVoidTeleportInterval()) {
            VoidTeleport.tryVoidTeleportEntities(this.field_76579_a, this.voidTeleport, this.skyTeleport);
            this.teleportCounter = 0;
        }
    }

    public float[] func_177497_p() {
        if (this.properties.getCustomLightBrightnessTable() != null) {
            return this.properties.getCustomLightBrightnessTable();
        }
        return super.func_177497_p();
    }

    public int getDayCycleLength() {
        return this.properties.getDayLength() + this.properties.getNightLength();
    }

    public void setWorldTime(long time) {
        time = WorldProviderJED.getNewWorldTime(time, this.getWorldTime(), this.properties);
        super.setWorldTime(time);
    }

    public void resetRainAndThunder() {
        if (!this.properties.getDontAdvanceWeatherWhenSleeping()) {
            super.resetRainAndThunder();
        }
    }

    public static long getNewWorldTime(long nextTime, long currentTime, JEDWorldProperties properties) {
        if (properties.getUseCustomDayTimeRange() && currentTime + 1L == nextTime) {
            int min = properties.getDayTimeMin();
            int max = properties.getDayTimeMax();
            int dayCycleLength = max - min + 1;
            if (nextTime % (long)dayCycleLength == 0L) {
                nextTime += (long)(properties.getDayCycleIncrement() - dayCycleLength);
            }
        }
        return nextTime;
    }

    public int func_76559_b(long worldTime) {
        long cycleLength = this.getDayCycleLength();
        return (int)(worldTime / cycleLength % 8L + 8L) % 8;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        if (this.properties.getUseCustomDayCycle()) {
            return WorldProviderJED.calculateCelestialAngle(this.field_76579_a, this.properties, this.getDayCycleLength(), worldTime, partialTicks);
        }
        if (this.properties.getUseCustomCelestialAngleRange()) {
            return WorldProviderJED.getCustomCelestialAngleValue(this.field_76579_a, this.properties, this.getDayCycleLength(), worldTime, partialTicks);
        }
        return super.func_76563_a(worldTime, partialTicks);
    }

    public static float calculateCelestialAngle(World world, JEDWorldProperties properties, int dayCycleLength, long worldTime, float partialTicks) {
        float angle;
        long dayTicks = worldTime % (long)dayCycleLength;
        int duskOrDawnLength = (int)(0.075f * (float)dayCycleLength);
        int dayLength = properties.getDayLength();
        int nightLength = properties.getNightLength();
        if (!world.func_82736_K().func_82766_b("doDaylightCycle")) {
            partialTicks = 0.0f;
        }
        if (dayTicks > (long)(dayCycleLength - duskOrDawnLength) || dayTicks < (long)(dayLength - duskOrDawnLength)) {
            dayTicks = dayTicks > (long)dayLength ? (dayTicks -= (long)(dayCycleLength - duskOrDawnLength)) : (dayTicks += (long)duskOrDawnLength);
            angle = ((float)dayTicks + partialTicks) / (float)dayLength * 0.65f + 0.675f;
        } else {
            angle = ((float)(dayTicks -= (long)(dayLength - duskOrDawnLength)) + partialTicks) / (float)nightLength * 0.35f + 0.325f;
        }
        if (angle > 1.0f) {
            angle -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)angle * Math.PI) + 1.0) / 2.0);
        angle += (f1 - angle) / 3.0f;
        return angle;
    }

    public static float getCustomCelestialAngleValue(World world, JEDWorldProperties properties, int dayCycleLength, long worldTime, float partialTicks) {
        long dayTicks = worldTime % (long)dayCycleLength;
        if (!world.func_82736_K().func_82766_b("doDaylightCycle")) {
            partialTicks = 0.0f;
        }
        float min = properties.getCelestialAngleMin();
        float max = properties.getCelestialAngleMax();
        return min + (max - min) * (((float)dayTicks + partialTicks) / (float)dayCycleLength);
    }

    public boolean func_76566_a(int x, int z) {
        Boolean ignore = this.properties.ignoreSpawnSuitability();
        if (ignore != null && ignore.booleanValue()) {
            return true;
        }
        return super.func_76566_a(x, z);
    }

    public boolean canDoLightning(Chunk chunk) {
        return this.properties.canDoLightning() != null ? this.properties.canDoLightning() : true;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.properties.canDoRainSnowIce() != null ? this.properties.canDoRainSnowIce() : true;
    }

    public boolean canBlockFreeze(BlockPos pos, boolean noWaterAdj) {
        if (this.properties.canDoRainSnowIce() != null) {
            return this.properties.canDoRainSnowIce() != false && WorldUtils.canBlockFreeze(this.field_76579_a, pos, noWaterAdj);
        }
        return super.canBlockFreeze(pos, noWaterAdj);
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        if (this.properties.canDoRainSnowIce() != null) {
            return this.properties.canDoRainSnowIce() != false && WorldUtils.canSnowAt(this.field_76579_a, pos);
        }
        return super.canSnowAt(pos, checkLight);
    }

    public boolean func_76568_b(int x, int z) {
        if (this.properties.getHasPerBiomeFog()) {
            return this.properties.doesBiomeHaveFog(this.field_76579_a.func_180494_b(new BlockPos(x, 0, z)));
        }
        return this.properties.getHasXZFog() != null ? this.properties.getHasXZFog() : this.hasXZFog;
    }

    public boolean func_76569_d() {
        return this.properties.isSurfaceWorld() != null ? this.properties.isSurfaceWorld() : this.isSurfaceWorld;
    }

    public int func_76557_i() {
        return this.properties.getAverageGroundLevel() != null ? this.properties.getAverageGroundLevel().intValue() : super.func_76557_i();
    }

    public double getHorizon() {
        return this.properties.getHorizon() != null ? this.properties.getHorizon().doubleValue() : super.getHorizon();
    }

    public double getMovementFactor() {
        return this.properties.getMovementFactor() != null ? this.properties.getMovementFactor() : this.movementFactor;
    }

    public float getSunBrightness(float partialTicks) {
        return this.properties.getSunBrightness() != null ? this.properties.getSunBrightness().floatValue() : super.getSunBrightness(partialTicks);
    }

    public float getSunBrightnessFactor(float partialTicks) {
        return this.properties.getSunBrightnessFactor() != null ? this.properties.getSunBrightnessFactor().floatValue() : super.getSunBrightnessFactor(partialTicks);
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return !this.func_76569_d();
    }

    public boolean shouldClientCheckLighting() {
        if (this.properties.shouldClientCheckLight() != null) {
            return this.properties.shouldClientCheckLight();
        }
        return !(this instanceof WorldProviderSurfaceJED);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public MusicTicker.MusicType getMusicType() {
        return ClientUtils.getMusicTypeFromProperties(this.properties);
    }

    @Nullable
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return this.properties.getDisableDawnDuskColors() ? null : super.func_76560_a(celestialAngle, partialTicks);
    }

    public Vec3d getSkyColor(Entity entity, float partialTicks) {
        float thunder;
        Vec3d skyColor = this.properties.getSkyColor();
        if (skyColor == null) {
            return super.getSkyColor(entity, partialTicks);
        }
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = new BlockPos(x, y, z);
        int blendColour = ForgeHooksClient.getSkyBlendColour((World)this.field_76579_a, (BlockPos)blockpos);
        float r = (float)(blendColour >> 16 & 0xFF) / 255.0f;
        float g = (float)(blendColour >> 8 & 0xFF) / 255.0f;
        float b = (float)(blendColour & 0xFF) / 255.0f;
        Float skyBlend = this.properties.getSkyBlendRatio();
        float blendRatio = skyBlend != null ? MathHelper.func_76131_a((float)skyBlend.floatValue(), (float)0.0f, (float)1.0f) : 0.0f;
        r = r * (float)skyColor.field_72450_a * (1.0f - blendRatio) + (float)skyColor.field_72450_a * blendRatio;
        g = g * (float)skyColor.field_72448_b * (1.0f - blendRatio) + (float)skyColor.field_72448_b * blendRatio;
        b = b * (float)skyColor.field_72449_c * (1.0f - blendRatio) + (float)skyColor.field_72449_c * blendRatio;
        float lightLevel = MathHelper.func_76134_b((float)this.field_76579_a.func_72929_e(partialTicks)) * 2.0f + 0.5f;
        lightLevel = MathHelper.func_76131_a((float)lightLevel, (float)0.0f, (float)1.0f);
        Float lightBlend = this.properties.getSkyColorLightBlendRatio();
        float lightBlendRatio = lightBlend != null ? MathHelper.func_76131_a((float)lightBlend.floatValue(), (float)0.0f, (float)1.0f) : 1.0f;
        r = r * lightLevel * lightBlendRatio + r * (1.0f - lightBlendRatio);
        g = g * lightLevel * lightBlendRatio + g * (1.0f - lightBlendRatio);
        b = b * lightLevel * lightBlendRatio + b * (1.0f - lightBlendRatio);
        float rain = this.field_76579_a.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float greyLevel = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f8 = 1.0f - rain * 0.75f;
            r = r * f8 + greyLevel * (1.0f - f8);
            g = g * f8 + greyLevel * (1.0f - f8);
            b = b * f8 + greyLevel * (1.0f - f8);
        }
        if ((thunder = this.field_76579_a.func_72819_i(partialTicks)) > 0.0f) {
            float greyLevel = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float f9 = 1.0f - thunder * 0.75f;
            r = r * f9 + greyLevel * (1.0f - f9);
            g = g * f9 + greyLevel * (1.0f - f9);
            b = b * f9 + greyLevel * (1.0f - f9);
        }
        if (this.field_76579_a.func_175658_ac() > 0) {
            float f12 = (float)this.field_76579_a.func_175658_ac() - partialTicks;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            r = r * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            g = g * (1.0f - f12) + 0.8f * f12;
            b = b * (1.0f - f12) + 1.0f * f12;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    public Vec3d getCloudColor(float partialTicks) {
        Vec3d cloudColor = this.properties.getCloudColor();
        if (cloudColor == null) {
            return super.getCloudColor(partialTicks);
        }
        float celestialAngle = MathHelper.func_76134_b((float)this.field_76579_a.func_72929_e(partialTicks)) * 2.0f + 0.5f;
        celestialAngle = MathHelper.func_76131_a((float)celestialAngle, (float)0.0f, (float)1.0f);
        float r = (float)cloudColor.field_72450_a;
        float g = (float)cloudColor.field_72448_b;
        float b = (float)cloudColor.field_72449_c;
        float rain = this.field_76579_a.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f6 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f7 = 1.0f - rain * 0.95f;
            r = r * f7 + f6 * (1.0f - f7);
            g = g * f7 + f6 * (1.0f - f7);
            b = b * f7 + f6 * (1.0f - f7);
        }
        r *= celestialAngle * 0.9f + 0.1f;
        g *= celestialAngle * 0.9f + 0.1f;
        b *= celestialAngle * 0.85f + 0.15f;
        float thunder = this.field_76579_a.func_72819_i(partialTicks);
        if (thunder > 0.0f) {
            float greyLevel = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float inverseThunderStrength = 1.0f - thunder * 0.95f;
            r = r * inverseThunderStrength + greyLevel * (1.0f - inverseThunderStrength);
            g = g * inverseThunderStrength + greyLevel * (1.0f - inverseThunderStrength);
            b = b * inverseThunderStrength + greyLevel * (1.0f - inverseThunderStrength);
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    public float func_76571_f() {
        return this.properties.getCloudHeight();
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Vec3d fogColor = this.properties.getFogColor();
        if (fogColor == null) {
            return super.func_76562_b(celestialAngle, partialTicks);
        }
        float celestialAngleRadians = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        celestialAngleRadians = MathHelper.func_76131_a((float)celestialAngleRadians, (float)0.0f, (float)1.0f);
        return fogColor.func_186678_a((double)celestialAngleRadians);
    }
}

