/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions;

import fi.dy.masa.justenoughdimensions.command.CommandJED;
import fi.dy.masa.justenoughdimensions.command.CommandTeleportJED;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.config.DimensionTypeEntry;
import fi.dy.masa.justenoughdimensions.event.DataTracker;
import fi.dy.masa.justenoughdimensions.network.DimensionSyncChannelHandler;
import fi.dy.masa.justenoughdimensions.network.PacketHandler;
import fi.dy.masa.justenoughdimensions.proxy.CommonProxy;
import fi.dy.masa.justenoughdimensions.util.world.WorldBorderUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldFileUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.WorldProviderEndJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderHellJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderSurfaceJED;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.util.EnumMap;
import java.util.Random;
import net.minecraft.command.ICommand;
import net.minecraft.world.DimensionType;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="justenoughdimensions", name="Just Enough Dimensions", version="1.6.0-dev.20190505.222902", certificateFingerprint="2b03e1423915a189b8094816baa18f239d576dff", guiFactory="fi.dy.masa.justenoughdimensions.config.JustEnoughDimensionsGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/justenoughdimensions/master/update.json", acceptedMinecraftVersions="1.12")
public class JustEnoughDimensions {
    @Mod.Instance(value="justenoughdimensions")
    public static JustEnoughDimensions instance;
    @SidedProxy(clientSide="fi.dy.masa.justenoughdimensions.proxy.ClientProxy", serverSide="fi.dy.masa.justenoughdimensions.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Random RAND;
    public static final Logger logger;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    private static File lastWorldDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        Configs.loadConfigsFromMainConfigFile(event.getModConfigurationDirectory());
        PacketHandler.init();
        proxy.registerEventHandlers();
        channels = NetworkRegistry.INSTANCE.newChannel("JEDChannel", new ChannelHandler[]{DimensionSyncChannelHandler.instance});
        DimensionConfig.init(event.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        File worldDir = new File(((AnvilSaveConverter)event.getServer().func_71254_M()).field_75808_a, event.getServer().func_71270_I());
        Configs.loadConfigsFromPerWorldConfigIfEnabled(worldDir);
        DimensionConfig.instance().readDimensionConfig(worldDir);
        DataTracker.getInstance().readFromDisk(worldDir);
        lastWorldDir = worldDir;
        DimensionConfig.instance().doEarlyDimensionRegistrations();
        WorldFileUtils.copyTemplateWorldIfApplicable(0, worldDir);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandJED());
        event.registerServerCommand((ICommand)new CommandTeleportJED());
        if (!event.getServer().func_71255_r() && DimensionManager.getStaticDimensionIDs().length > 1) {
            logger.warn("******************************************************************************************");
            logger.warn("**  The 'disable-nether' option is currently disabled in 'server.properties'.");
            logger.warn("**  Just a friendly FYI, because this has been the cause of some weird and");
            logger.warn("**  hard to pinpoint issues for some users, before it was found out that the");
            logger.warn("**  above mentioned option was disabled in the hopes of simply disabling just the Nether.");
            logger.warn("**  That's not what that option does.");
            logger.warn("**  It actually prevents ANY DIMENSIONS except for dimension 0 from being ticked at all!!");
            logger.warn("**  Thus it basically makes any dimensions except for the overworld unusable,");
            logger.warn("**  and any player trying to go to other dimensions will get stuck in limbo.");
            logger.warn("******************************************************************************************");
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        WorldBorderUtils.removeDefaultBorderListeners();
        DimensionConfig.instance().registerNonOverrideDimensions();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        WorldUtils.removeTemporaryWorldIfApplicable(0, null, lastWorldDir, true);
        lastWorldDir = null;
        DimensionConfig.instance().unregisterCustomDimensions();
        Configs.loadConfigsFromGlobalConfigFile();
    }

    public static void logInfo(String message, Object ... params) {
        if (Configs.enableLoggingInfo) {
            logger.info(message, params);
        } else {
            logger.trace(message, params);
        }
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"Just Enough Dimensions");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    static {
        RAND = new Random();
        logger = LogManager.getLogger((String)"justenoughdimensions");
        DimensionTypeEntry.cache(DimensionType.register((String)"JED Surface", (String)"_dim7891", (int)7891, WorldProviderSurfaceJED.class, (boolean)false));
        DimensionTypeEntry.cache(DimensionType.register((String)"JED Surface 0", (String)"", (int)0, WorldProviderSurfaceJED.class, (boolean)false));
        DimensionTypeEntry.cache(DimensionType.register((String)"JED Surface Loaded 0", (String)"_dim0", (int)0, WorldProviderSurfaceJED.class, (boolean)true));
        DimensionTypeEntry.cache(DimensionType.register((String)"JED Hell", (String)"_dim-1", (int)-1, WorldProviderHellJED.class, (boolean)false));
        DimensionTypeEntry.cache(DimensionType.register((String)"JED End", (String)"_dim1", (int)1, WorldProviderEndJED.class, (boolean)false));
    }
}

