/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.fluids.container.ContainerFluidConfigurable;
import appeng.fluids.parts.PartFluidStorageBus;
import appeng.fluids.util.IAEFluidTank;
import appeng.me.storage.MEInventoryHandler;
import appeng.util.Platform;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.items.IItemHandler;

public class ContainerFluidStorageBus
extends ContainerFluidConfigurable {
    private final PartFluidStorageBus storageBus;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;

    public ContainerFluidStorageBus(InventoryPlayer ip, PartFluidStorageBus te) {
        super(ip, te);
        this.storageBus = te;
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        int upgrades;
        int y;
        return !this.supportCapacity() || (y = slot / 9) < (upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY)) + 2;
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.setFuzzyMode((FuzzyMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FUZZY_MODE));
            this.setReadWriteMode((AccessRestriction)this.getUpgradeable().getConfigManager().getSetting(Settings.ACCESS));
            this.setStorageFilter((StorageFilter)this.getUpgradeable().getConfigManager().getSetting(Settings.STORAGE_FILTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    public void clear() {
        IAEFluidTank h = this.storageBus.getConfig();
        for (int i = 0; i < h.getSlots(); ++i) {
            h.setFluidInSlot(i, null);
        }
        this.func_75142_b();
    }

    public void partition() {
        IAEFluidTank h = this.storageBus.getConfig();
        MEInventoryHandler<IAEFluidStack> cellInv = this.storageBus.getInternalHandler();
        Iterator i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList());
            i = list.iterator();
        }
        for (int x = 0; x < h.getSlots(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                h.setFluidInSlot(x, (IAEFluidStack)i.next());
                continue;
            }
            h.setFluidInSlot(x, null);
        }
        this.func_75142_b();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.storageBus.getConfig();
    }
}

