/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.util.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class EnderLetterHandler
extends WorldSavedData {
    public static String ID = "RTEnderLetters";
    HashMap<UUID, EnderMailboxInventory> inventoryMap = new HashMap();

    public EnderLetterHandler(String name) {
        super(name);
    }

    public EnderLetterHandler() {
        super(ID);
    }

    public EnderMailboxInventory getOrCreateInventoryForPlayer(UUID playerUUID) {
        if (this.inventoryMap.containsKey(playerUUID)) {
            return this.inventoryMap.get(playerUUID);
        }
        this.inventoryMap.put(playerUUID, new EnderMailboxInventory(this));
        this.func_76185_a();
        return this.inventoryMap.get(playerUUID);
    }

    public static EnderLetterHandler get(World worldObj) {
        EnderLetterHandler handler = (EnderLetterHandler)worldObj.func_72943_a(EnderLetterHandler.class, ID);
        if (handler == null) {
            handler = new EnderLetterHandler();
            worldObj.func_72823_a(ID, (WorldSavedData)handler);
        }
        return handler;
    }

    public boolean hasInventoryFor(UUID playerUUID) {
        return this.inventoryMap.containsKey(playerUUID);
    }

    public void func_76184_a(NBTTagCompound modNBT) {
        NBTTagCompound compound = modNBT.func_74775_l("enderLetters");
        NBTTagList nbtList = compound.func_150295_c("entryList", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = nbtList.func_150305_b(i);
            UUID uuid = UUID.fromString(entryCompound.func_74779_i("uuid"));
            EnderMailboxInventory inventory = new EnderMailboxInventory(this);
            inventory.readFromNBT(entryCompound.func_74775_l("inventory"));
            this.inventoryMap.put(uuid, inventory);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound modNBT) {
        NBTTagCompound compound = modNBT.func_74775_l("enderLetters");
        NBTTagList nbtList = new NBTTagList();
        for (Map.Entry<UUID, EnderMailboxInventory> mapEntry : this.inventoryMap.entrySet()) {
            NBTTagCompound entryCompound = new NBTTagCompound();
            entryCompound.func_74778_a("uuid", mapEntry.getKey().toString());
            NBTTagCompound inventoryCompound = new NBTTagCompound();
            mapEntry.getValue().writeToNBT(inventoryCompound);
            entryCompound.func_74782_a("inventory", (NBTBase)inventoryCompound);
            nbtList.func_74742_a((NBTBase)entryCompound);
        }
        compound.func_74782_a("entryList", (NBTBase)nbtList);
        modNBT.func_74782_a("enderLetters", (NBTBase)compound);
        return modNBT;
    }

    public static class EnderMailboxInventory
    implements IInventory {
        NonNullList<ItemStack> enderLetters = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        EnderLetterHandler handler;

        public EnderMailboxInventory(EnderLetterHandler handler) {
            this.handler = handler;
        }

        public void writeToNBT(NBTTagCompound compound) {
            InventoryUtil.writeInventoryToCompound(compound, this);
        }

        public void readFromNBT(NBTTagCompound compound) {
            InventoryUtil.readInventoryFromCompound(compound, this);
        }

        public String func_70005_c_() {
            return "tile.enderMailbox";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return 9;
        }

        public ItemStack func_70301_a(int index) {
            return (ItemStack)this.enderLetters.get(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            if (!((ItemStack)this.enderLetters.get(index)).func_190926_b()) {
                if (((ItemStack)this.enderLetters.get(index)).func_190916_E() <= count) {
                    ItemStack itemstack = (ItemStack)this.enderLetters.get(index);
                    this.enderLetters.set(index, (Object)ItemStack.field_190927_a);
                    this.func_70296_d();
                    return itemstack;
                }
                ItemStack itemstack = ((ItemStack)this.enderLetters.get(index)).func_77979_a(count);
                if (((ItemStack)this.enderLetters.get(index)).func_190916_E() == 0) {
                    this.enderLetters.set(index, (Object)ItemStack.field_190927_a);
                }
                this.func_70296_d();
                return itemstack;
            }
            return null;
        }

        public ItemStack func_70304_b(int index) {
            if (!((ItemStack)this.enderLetters.get(index)).func_190926_b()) {
                ItemStack itemstack = (ItemStack)this.enderLetters.get(index);
                this.enderLetters.set(index, (Object)ItemStack.field_190927_a);
                return itemstack;
            }
            return null;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.enderLetters.set(index, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            if (this.handler != null) {
                this.handler.func_76185_a();
            }
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return stack.func_77973_b() == ModItems.enderLetter;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            for (int i = 0; i < this.enderLetters.size(); ++i) {
                this.enderLetters.set(i, (Object)ItemStack.field_190927_a);
            }
        }

        public boolean func_191420_l() {
            for (ItemStack itemstack : this.enderLetters) {
                if (itemstack.func_190926_b()) continue;
                return false;
            }
            return true;
        }
    }
}

