/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.tileentity.TileEntityRainShield;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRainShield
extends BlockContainerBase {
    protected static final AxisAlignedBB RAINSHIELD_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    protected BlockRainShield() {
        super("rainShield", Material.field_151576_e);
        this.func_149711_c(2.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return RAINSHIELD_AABB;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
        TileEntityRainShield te = (TileEntityRainShield)worldIn.func_175625_s(pos);
        te.onBlockAdded(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceOn(worldIn, pos.func_177977_b());
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRainShield();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(state, worldIn, pos, rand);
        if (worldIn.func_72896_J()) {
            for (double mod = 0.0; mod < 1.0; mod += (double)0.1f) {
                for (double a = 0.0; a <= Math.PI * 2; a += 2.0943951023931953) {
                    double x = (double)pos.func_177958_n() + 0.5 + (1.0 - mod) * Math.cos(a);
                    double z = (double)pos.func_177952_p() + 0.5 + (1.0 - mod) * Math.sin(a);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, x, (double)((float)pos.func_177956_o() + 0.7f) + mod, z, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, (double)((float)pos.func_177956_o() + 0.6f) + mod, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityRainShield) {
            ((TileEntityRainShield)te).neighborChanged(state, worldIn, pos, neighborBlock, changedPos);
        }
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos, EnumFacing.UP);
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceOn(worldIn, pos.func_177977_b())) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }
}

