/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.entity.ai;

import me.ichun.mods.mmec.common.core.SoundIndex;
import me.ichun.mods.mmec.common.entity.EntityEggBomb;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import me.ichun.mods.mmec.common.entity.ai.EntityAICharging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class EntityAISpinningAttack
extends EntityAIBase {
    public EntityEnderChicken chicken;
    public float chance;
    public int time;

    public EntityAISpinningAttack(EntityEnderChicken chicken, float chance) {
        this.chicken = chicken;
        this.chance = chance;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.chicken.getClearingArea() || this.chicken.getSpinning()) {
            return false;
        }
        EntityLivingBase target = this.chicken.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        return this.chicken.canUseAbility() && this.chicken.getEggState() < 0 && !this.chicken.getFiring() && this.chicken.func_70089_S() && this.chicken.func_70681_au().nextFloat() < this.chance;
    }

    public boolean func_75253_b() {
        return this.chicken.func_70089_S() && this.time < 140;
    }

    public void func_75249_e() {
        this.chicken.useAbility();
        this.time = 0;
        this.chicken.setSpinning(true);
    }

    public void func_75251_c() {
        this.chicken.endAbility();
        this.chicken.setSpinning(false);
    }

    public void func_75246_d() {
        ++this.time;
        if (this.time == 1) {
            this.chicken.func_184185_a(SoundIndex.ender_death, 0.3f * this.chicken.getScale(), 1.0f);
        }
        if (this.time > 10) {
            float eggChance = (float)this.time / 140.0f * 0.5f;
            if (this.chicken.func_70681_au().nextFloat() < eggChance) {
                float scale = this.chicken.getScale();
                Vec3d buttPos = this.chicken.getHeadPos(-0.5, 0.02);
                EntityEggBomb egg = new EntityEggBomb(this.chicken.field_70170_p, scale, this.chicken.func_70638_az(), false, this.chicken.getIsChaos());
                egg.func_70012_b(buttPos.field_72450_a, buttPos.field_72448_b, buttPos.field_72449_c, this.chicken.field_70761_aq - 180.0f, 0.0f);
                double x = -MathHelper.func_76126_a((float)((this.chicken.field_70761_aq + 180.0f) * ((float)Math.PI / 180)));
                double z = MathHelper.func_76134_b((float)((this.chicken.field_70761_aq + 180.0f) * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
                x /= (double)f1;
                z /= (double)f1;
                x = x * 0.14 * (double)scale;
                z = z * 0.14 * (double)scale;
                egg.field_70159_w = x + this.chicken.field_70159_w;
                egg.field_70179_y = z + this.chicken.field_70179_y;
                this.chicken.func_184185_a(SoundEvents.field_187665_Y, 1.0f + 0.2f * scale, (this.chicken.func_70681_au().nextFloat() - this.chicken.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                this.chicken.field_70170_p.func_72838_d((Entity)egg);
            }
        }
        EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partWingL.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partWingL.field_70130_N / 3.0));
        EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partWingR.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partWingR.field_70130_N / 3.0));
        if (this.chicken.isHeadAvailable()) {
            EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partHead.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partHead.field_70130_N / 3.0));
            EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partBill.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partBill.field_70130_N / 3.0));
        }
    }
}

