/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.ichun.mods.mmec.common.MightyEnderChicken;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityEvent;

public class ChunkLoadHandler
implements ForgeChunkManager.LoadingCallback {
    public static LinkedHashMap<EntityEnderChicken, ForgeChunkManager.Ticket> entToTicketMap = new LinkedHashMap();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (MightyEnderChicken.config.chickensChunkload == 1) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                if (ticket.getEntity() instanceof EntityEnderChicken) {
                    EntityEnderChicken epp = (EntityEnderChicken)ticket.getEntity();
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(epp.func_180425_c()));
                    entToTicketMap.put(epp, ticket);
                    while (entToTicketMap.size() > 20) {
                        Iterator<Map.Entry<EntityEnderChicken, ForgeChunkManager.Ticket>> ite = entToTicketMap.entrySet().iterator();
                        if (!ite.hasNext()) continue;
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ite.next().getValue());
                        ite.remove();
                    }
                    continue;
                }
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    public static void checkAndCreateTicket(EntityEvent.EnteringChunk event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityEnderChicken && !event.getEntity().field_70128_L) {
            EntityEnderChicken epp = (EntityEnderChicken)event.getEntity();
            ForgeChunkManager.Ticket ticket = entToTicketMap.get(epp);
            if (ticket == null && (ticket = ForgeChunkManager.requestTicket((Object)MightyEnderChicken.instance, (World)epp.func_130014_f_(), (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY)) != null) {
                ticket.bindEntity((Entity)epp);
                entToTicketMap.put(epp, ticket);
            }
            if (ticket != null) {
                if (event.getOldChunkX() != 0 && event.getOldChunkZ() != 0) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(event.getOldChunkX(), event.getOldChunkZ()));
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(event.getNewChunkX(), event.getNewChunkZ()));
            }
        }
    }

    public static void removeTicket(EntityEnderChicken epp) {
        if (MightyEnderChicken.config.chickensChunkload == 1) {
            ForgeChunkManager.Ticket ticket = entToTicketMap.get(epp);
            if (ticket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
            entToTicketMap.remove(epp);
        }
    }
}

