/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.rules;

import com.google.common.base.Optional;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.tools.cache.StructureCache;
import mcjty.tools.rules.CommonRuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.Key;
import mcjty.tools.varia.LookAtTools;
import mcjty.tools.varia.Tools;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class CommonRuleEvaluator {
    protected final List<BiFunction<Event, IEventQuery, Boolean>> checks = new ArrayList<BiFunction<Event, IEventQuery, Boolean>>();
    private final Logger logger;
    private final IModRuleCompatibilityLayer compatibility;
    private static Random rnd = new Random();
    private static final int[] EMPTYINTS = new int[0];

    public CommonRuleEvaluator(AttributeMap map, Logger logger, IModRuleCompatibilityLayer compatibility) {
        this.logger = logger;
        this.compatibility = compatibility;
        this.addChecks(map);
    }

    protected void addChecks(AttributeMap map) {
        if (map.has(CommonRuleKeys.RANDOM)) {
            this.addRandomCheck(map);
        }
        if (map.has(CommonRuleKeys.DIMENSION)) {
            this.addDimensionCheck(map);
        }
        if (map.has(CommonRuleKeys.MINTIME)) {
            this.addMinTimeCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXTIME)) {
            this.addMaxTimeCheck(map);
        }
        if (map.has(CommonRuleKeys.MINHEIGHT)) {
            this.addMinHeightCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXHEIGHT)) {
            this.addMaxHeightCheck(map);
        }
        if (map.has(CommonRuleKeys.WEATHER)) {
            this.addWeatherCheck(map);
        }
        if (map.has(CommonRuleKeys.TEMPCATEGORY)) {
            this.addTempCategoryCheck(map);
        }
        if (map.has(CommonRuleKeys.DIFFICULTY)) {
            this.addDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.MINSPAWNDIST)) {
            this.addMinSpawnDistCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXSPAWNDIST)) {
            this.addMaxSpawnDistCheck(map);
        }
        if (map.has(CommonRuleKeys.MINLIGHT)) {
            this.addMinLightCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXLIGHT)) {
            this.addMaxLightCheck(map);
        }
        if (map.has(CommonRuleKeys.MINDIFFICULTY)) {
            this.addMinAdditionalDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXDIFFICULTY)) {
            this.addMaxAdditionalDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.SEESKY)) {
            this.addSeeSkyCheck(map);
        }
        if (map.has(CommonRuleKeys.BLOCK)) {
            this.addBlocksCheck(map);
        }
        if (map.has(CommonRuleKeys.BIOME)) {
            this.addBiomesCheck(map);
        }
        if (map.has(CommonRuleKeys.BIOMETYPE)) {
            this.addBiomeTypesCheck(map);
        }
        if (map.has(CommonRuleKeys.HELMET)) {
            this.addHelmetCheck(map);
        }
        if (map.has(CommonRuleKeys.CHESTPLATE)) {
            this.addChestplateCheck(map);
        }
        if (map.has(CommonRuleKeys.LEGGINGS)) {
            this.addLeggingsCheck(map);
        }
        if (map.has(CommonRuleKeys.BOOTS)) {
            this.addBootsCheck(map);
        }
        if (map.has(CommonRuleKeys.HELDITEM)) {
            this.addHeldItemCheck(map);
        }
        if (map.has(CommonRuleKeys.OFFHANDITEM)) {
            this.addOffHandItemCheck(map);
        }
        if (map.has(CommonRuleKeys.BOTHHANDSITEM)) {
            this.addBothHandsItemCheck(map);
        }
        if (map.has(CommonRuleKeys.STRUCTURE)) {
            this.addStructureCheck(map);
        }
        if (map.has(CommonRuleKeys.STATE)) {
            if (this.compatibility.hasEnigmaScript()) {
                this.addStateCheck(map);
            } else {
                this.logger.warn("EnigmaScript is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.PSTATE)) {
            if (this.compatibility.hasEnigmaScript()) {
                this.addPStateCheck(map);
            } else {
                this.logger.warn("EnigmaScript is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.SUMMER)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addSummerCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.WINTER)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addWinterCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.SPRING)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addSpringCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.AUTUMN)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addAutumnCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.GAMESTAGE)) {
            if (this.compatibility.hasGameStages()) {
                this.addGameStageCheck(map);
            } else {
                this.logger.warn("Game Stages is missing: the 'gamestage' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INCITY)) {
            if (this.compatibility.hasLostCities()) {
                this.addInCityCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'incity' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INSTREET)) {
            if (this.compatibility.hasLostCities()) {
                this.addInStreetCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'instreet' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INSPHERE)) {
            if (this.compatibility.hasLostCities()) {
                this.addInSphereCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'insphere' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INBUILDING)) {
            if (this.compatibility.hasLostCities()) {
                this.addInBuildingCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'inbuilding' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.AMULET)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.AMULET, this.compatibility::getAmuletSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.RING)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.RING, this.compatibility::getRingSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.BELT)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.BELT, this.compatibility::getBeltSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.TRINKET)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.TRINKET, this.compatibility::getTrinketSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.HEAD)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.HEAD, this.compatibility::getHeadSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.BODY)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.BODY, this.compatibility::getBodySlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.CHARM)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.CHARM, this.compatibility::getCharmSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
    }

    private void addRandomCheck(AttributeMap map) {
        float r = map.get(CommonRuleKeys.RANDOM).floatValue();
        this.checks.add((event, query) -> rnd.nextFloat() < r);
    }

    private void addSeeSkyCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.SEESKY).booleanValue()) {
            this.checks.add((event, query) -> query.getWorld(event).func_175710_j(query.getPos(event)));
        } else {
            this.checks.add((event, query) -> !query.getWorld(event).func_175710_j(query.getPos(event)));
        }
    }

    private void addDimensionCheck(AttributeMap map) {
        List<Integer> dimensions = map.getList(CommonRuleKeys.DIMENSION);
        if (dimensions.size() == 1) {
            Integer dim = dimensions.get(0);
            this.checks.add((event, query) -> query.getWorld(event).field_73011_w.getDimension() == dim.intValue());
        } else {
            HashSet<Integer> dims = new HashSet<Integer>(dimensions);
            this.checks.add((event, query) -> dims.contains(query.getWorld(event).field_73011_w.getDimension()));
        }
    }

    private void addDifficultyCheck(AttributeMap map) {
        String difficulty = map.get(CommonRuleKeys.DIFFICULTY).toLowerCase();
        EnumDifficulty diff = null;
        for (EnumDifficulty d : EnumDifficulty.values()) {
            if (!d.func_151526_b().endsWith("." + difficulty)) continue;
            diff = d;
            break;
        }
        if (diff != null) {
            EnumDifficulty finalDiff = diff;
            this.checks.add((event, query) -> query.getWorld(event).func_175659_aa() == finalDiff);
        } else {
            this.logger.log(Level.ERROR, "Unknown difficulty '" + difficulty + "'! Use one of 'easy', 'normal', 'hard',  or 'peaceful'");
        }
    }

    private void addWeatherCheck(AttributeMap map) {
        String weather = map.get(CommonRuleKeys.WEATHER);
        boolean raining = weather.toLowerCase().startsWith("rain");
        boolean thunder = weather.toLowerCase().startsWith("thunder");
        if (raining) {
            this.checks.add((event, query) -> query.getWorld(event).func_72896_J());
        } else if (thunder) {
            this.checks.add((event, query) -> query.getWorld(event).func_72911_I());
        } else {
            this.logger.log(Level.ERROR, "Unknown weather '" + weather + "'! Use 'rain' or 'thunder'");
        }
    }

    private void addTempCategoryCheck(AttributeMap map) {
        String tempcategory = map.get(CommonRuleKeys.TEMPCATEGORY).toLowerCase();
        Biome.TempCategory cat = null;
        if ("cold".equals(tempcategory)) {
            cat = Biome.TempCategory.COLD;
        } else if ("medium".equals(tempcategory)) {
            cat = Biome.TempCategory.MEDIUM;
        } else if ("warm".equals(tempcategory)) {
            cat = Biome.TempCategory.WARM;
        } else if ("ocean".equals(tempcategory)) {
            cat = Biome.TempCategory.OCEAN;
        } else {
            this.logger.log(Level.ERROR, "Unknown tempcategory '" + tempcategory + "'! Use one of 'cold', 'medium', 'warm',  or 'ocean'");
            return;
        }
        Biome.TempCategory finalCat = cat;
        this.checks.add((event, query) -> {
            Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
            return biome.func_150561_m() == finalCat;
        });
    }

    private void addStructureCheck(AttributeMap map) {
        String structure = map.get(CommonRuleKeys.STRUCTURE);
        this.checks.add((event, query) -> StructureCache.CACHE.isInStructure(query.getWorld(event), structure, query.getPos(event)));
    }

    private void addBiomesCheck(AttributeMap map) {
        List<String> biomes = map.getList(CommonRuleKeys.BIOME);
        if (biomes.size() == 1) {
            String biomename = biomes.get(0);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return biomename.equals(this.compatibility.getBiomeName(biome));
            });
        } else {
            HashSet<String> biomenames = new HashSet<String>(biomes);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return biomenames.contains(this.compatibility.getBiomeName(biome));
            });
        }
    }

    private void addBiomeTypesCheck(AttributeMap map) {
        List<String> biomeTypes = map.getList(CommonRuleKeys.BIOMETYPE);
        if (biomeTypes.size() == 1) {
            String biometype = biomeTypes.get(0);
            BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)biometype, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return BiomeDictionary.getTypes((Biome)biome).contains(type);
            });
        } else {
            HashSet<BiomeDictionary.Type> types = new HashSet<BiomeDictionary.Type>();
            for (String s : biomeTypes) {
                types.add(BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return BiomeDictionary.getTypes((Biome)biome).stream().anyMatch(s -> types.contains(s));
            });
        }
    }

    public static <T extends Comparable<T>> IBlockState set(IBlockState state, IProperty<T> property, String value) {
        Optional optionalValue = property.func_185929_b(value);
        if (optionalValue.isPresent()) {
            return state.func_177226_a(property, (Comparable)optionalValue.get());
        }
        return state;
    }

    @Nonnull
    private BiFunction<Event, IEventQuery, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = 0;
            offsetY = 0;
            offsetZ = 0;
        }
        if (obj.has("look")) {
            return (event, query) -> {
                RayTraceResult result = LookAtTools.getMovingObjectPositionFromPlayer(query.getWorld(event), query.getPlayer(event), false);
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    return result.func_178782_a().func_177982_a(offsetX, offsetY, offsetZ);
                }
                return query.getValidBlockPos(event).func_177982_a(offsetX, offsetY, offsetZ);
            };
        }
        return (event, query) -> query.getValidBlockPos(event).func_177982_a(offsetX, offsetY, offsetZ);
    }

    @Nullable
    private BiPredicate<World, BlockPos> parseBlock(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            if (blockname.startsWith("ore:")) {
                int oreId = OreDictionary.getOreID((String)blockname.substring(4));
                return (world, pos) -> this.isMatchingOreDict(oreId, world.func_180495_p(pos).func_177230_c());
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                this.logger.log(Level.ERROR, "Block '" + blockname + "' is not valid!");
                return null;
            }
            return (world, pos) -> world.func_180495_p(pos).func_177230_c() == block;
        }
        if (element.isJsonObject()) {
            BiPredicate<World, BlockPos> finalTest;
            Predicate<Integer> energy;
            BiPredicate<World, BlockPos> test;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("ore")) {
                int oreId = OreDictionary.getOreID((String)obj.get("ore").getAsString());
                test = (world, pos) -> this.isMatchingOreDict(oreId, world.func_180495_p(pos).func_177230_c());
            } else if (obj.has("block")) {
                String blockname = obj.get("block").getAsString();
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
                if (block == null) {
                    this.logger.log(Level.ERROR, "Block '" + blockname + "' is not valid!");
                    return null;
                }
                if (obj.has("properties")) {
                    IBlockState blockState = block.func_176223_P();
                    JsonArray propArray = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : propArray) {
                        JsonObject propObj = el.getAsJsonObject();
                        String name = propObj.get("name").getAsString();
                        String value = propObj.get("value").getAsString();
                        for (IProperty key : blockState.func_177227_a()) {
                            if (!name.equals(key.func_177701_a())) continue;
                            blockState = CommonRuleEvaluator.set(blockState, key, value);
                        }
                    }
                    IBlockState finalBlockState = blockState;
                    test = (world, pos) -> world.func_180495_p(pos) == finalBlockState;
                } else {
                    test = (world, pos) -> world.func_180495_p(pos).func_177230_c() == block;
                }
            } else {
                test = (world, pos) -> true;
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                BiPredicate<World, BlockPos> finalTest2 = test;
                test = (world, pos) -> finalTest2.test((World)world, (BlockPos)pos) && mod.equals(world.func_180495_p(pos).func_177230_c().getRegistryName().func_110624_b());
            }
            if (obj.has("energy") && (energy = this.getExpression(obj.get("energy"))) != null) {
                EnumFacing side = obj.has("side") ? EnumFacing.func_176739_a((String)obj.get("side").getAsString().toLowerCase()) : null;
                finalTest = test;
                test = (world, pos) -> finalTest.test((World)world, (BlockPos)pos) && energy.test(this.getEnergy((World)world, (BlockPos)pos, side));
            }
            if (obj.has("contains")) {
                EnumFacing side = obj.has("side") ? EnumFacing.func_176739_a((String)obj.get("energyside").getAsString().toLowerCase()) : null;
                List<Predicate<ItemStack>> items = this.getItems(obj.get("contains"));
                finalTest = test;
                test = (world, pos) -> finalTest.test((World)world, (BlockPos)pos) && this.contains((World)world, (BlockPos)pos, side, items);
            }
            return test;
        }
        this.logger.log(Level.ERROR, "Block description '" + json + "' is not valid!");
        return null;
    }

    protected List<Predicate<ItemStack>> getItems(JsonElement itemObj) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        if (itemObj.isJsonObject()) {
            Predicate<ItemStack> matcher = this.getMatcher(itemObj.getAsJsonObject());
            if (matcher != null) {
                items.add(matcher);
            }
        } else if (itemObj.isJsonArray()) {
            for (JsonElement element : itemObj.getAsJsonArray()) {
                JsonObject obj = element.getAsJsonObject();
                Predicate<ItemStack> matcher = this.getMatcher(obj);
                if (matcher == null) continue;
                items.add(matcher);
            }
        } else {
            this.logger.log(Level.ERROR, "Item description is not valid!");
        }
        return items;
    }

    private boolean isMatchingOreDict(int oreId, Block block) {
        ItemStack stack = new ItemStack(block);
        int[] oreIDs = stack.func_190926_b() ? EMPTYINTS : OreDictionary.getOreIDs((ItemStack)stack);
        return this.isMatchingOreId(oreIDs, oreId);
    }

    private void addBlocksCheck(AttributeMap map) {
        BiFunction<Event, IEventQuery, BlockPos> posFunction = map.has(CommonRuleKeys.BLOCKOFFSET) ? this.parseOffset(map.get(CommonRuleKeys.BLOCKOFFSET)) : (event, query) -> query.getValidBlockPos(event);
        List<String> blocks = map.getList(CommonRuleKeys.BLOCK);
        if (blocks.size() == 1) {
            String json = blocks.get(0);
            BiPredicate<World, BlockPos> blockMatcher = this.parseBlock(json);
            if (blockMatcher != null) {
                this.checks.add((event, query) -> {
                    BlockPos pos = (BlockPos)posFunction.apply((Event)event, (IEventQuery)query);
                    return pos != null && blockMatcher.test(query.getWorld(event), pos);
                });
            }
        } else {
            ArrayList<BiPredicate<World, BlockPos>> blockMatchers = new ArrayList<BiPredicate<World, BlockPos>>();
            for (String block : blocks) {
                BiPredicate<World, BlockPos> blockMatcher = this.parseBlock(block);
                if (blockMatcher == null) {
                    return;
                }
                blockMatchers.add(blockMatcher);
            }
            this.checks.add((event, query) -> {
                BlockPos pos = (BlockPos)posFunction.apply((Event)event, (IEventQuery)query);
                if (pos != null) {
                    World world = query.getWorld(event);
                    for (BiPredicate matcher : blockMatchers) {
                        if (!matcher.test(world, pos)) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }

    private boolean isMatchingOreId(int[] oreIDs, int oreId) {
        if (oreIDs.length > 0) {
            for (int id : oreIDs) {
                if (id != oreId) continue;
                return true;
            }
        }
        return false;
    }

    private void addMinTimeCheck(AttributeMap map) {
        int mintime = map.get(CommonRuleKeys.MINTIME);
        this.checks.add((event, query) -> {
            int time = (int)query.getWorld(event).func_72820_D();
            return time >= mintime;
        });
    }

    private void addMaxTimeCheck(AttributeMap map) {
        int maxtime = map.get(CommonRuleKeys.MAXTIME);
        this.checks.add((event, query) -> {
            int time = (int)query.getWorld(event).func_72820_D();
            return time <= maxtime;
        });
    }

    private void addMinSpawnDistCheck(AttributeMap map) {
        Float d = Float.valueOf(map.get(CommonRuleKeys.MINSPAWNDIST).floatValue() * map.get(CommonRuleKeys.MINSPAWNDIST).floatValue());
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            double sqdist = pos.func_177951_i((Vec3i)query.getWorld(event).func_175694_M());
            return sqdist >= (double)d.floatValue();
        });
    }

    private void addMaxSpawnDistCheck(AttributeMap map) {
        Float d = Float.valueOf(map.get(CommonRuleKeys.MAXSPAWNDIST).floatValue() * map.get(CommonRuleKeys.MAXSPAWNDIST).floatValue());
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            double sqdist = pos.func_177951_i((Vec3i)query.getWorld(event).func_175694_M());
            return sqdist <= (double)d.floatValue();
        });
    }

    private void addMinLightCheck(AttributeMap map) {
        int minlight = map.get(CommonRuleKeys.MINLIGHT);
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            return query.getWorld(event).func_175721_c(pos, true) >= minlight;
        });
    }

    private void addMaxLightCheck(AttributeMap map) {
        int maxlight = map.get(CommonRuleKeys.MAXLIGHT);
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            return query.getWorld(event).func_175721_c(pos, true) <= maxlight;
        });
    }

    private void addMinAdditionalDifficultyCheck(AttributeMap map) {
        Float mindifficulty = map.get(CommonRuleKeys.MINDIFFICULTY);
        this.checks.add((event, query) -> query.getWorld(event).func_175649_E(query.getPos(event)).func_180168_b() >= mindifficulty.floatValue());
    }

    private void addMaxAdditionalDifficultyCheck(AttributeMap map) {
        Float maxdifficulty = map.get(CommonRuleKeys.MAXDIFFICULTY);
        this.checks.add((event, query) -> query.getWorld(event).func_175649_E(query.getPos(event)).func_180168_b() <= maxdifficulty.floatValue());
    }

    private void addMaxHeightCheck(AttributeMap map) {
        int maxheight = map.get(CommonRuleKeys.MAXHEIGHT);
        this.checks.add((event, query) -> query.getY(event) <= maxheight);
    }

    private void addMinHeightCheck(AttributeMap map) {
        int minheight = map.get(CommonRuleKeys.MINHEIGHT);
        this.checks.add((event, query) -> query.getY(event) >= minheight);
    }

    public boolean match(Event event, IEventQuery query) {
        for (BiFunction<Event, IEventQuery, Boolean> rule : this.checks) {
            if (rule.apply(event, query).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Predicate<Integer> getExpression(String expression) {
        try {
            if (expression.startsWith(">=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i >= amount;
            }
            if (expression.startsWith(">")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i > amount;
            }
            if (expression.startsWith("<=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i <= amount;
            }
            if (expression.startsWith("<")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i < amount;
            }
            if (expression.startsWith("=")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i == amount;
            }
            if (expression.startsWith("!=") || expression.startsWith("<>")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i != amount;
            }
            if (expression.contains("-")) {
                String[] split = StringUtils.split((String)expression, (String)"-");
                int amount1 = Integer.parseInt(split[0]);
                int amount2 = Integer.parseInt(split[1]);
                return i -> i >= amount1 && i <= amount2;
            }
            int amount = Integer.parseInt(expression);
            return i -> i == amount;
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.ERROR, "Bad expression '" + expression + "'!");
            return null;
        }
    }

    private Predicate<Integer> getExpression(JsonElement element) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return i -> i == amount;
            }
            return this.getExpression(element.getAsString());
        }
        this.logger.log(Level.ERROR, "Bad expression!");
        return null;
    }

    private Predicate<ItemStack> getMatcher(String name) {
        ItemStack stack = Tools.parseStack(name, this.logger);
        if (!stack.func_190926_b()) {
            if (name.contains("/") && name.contains("@")) {
                return s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("/")) {
                return s -> ItemStack.func_185132_d((ItemStack)s, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("@")) {
                return s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack);
            }
            return s -> s.func_77973_b() == stack.func_77973_b();
        }
        return null;
    }

    private Predicate<ItemStack> getMatcher(JsonObject obj) {
        Predicate<Integer> energy;
        List<Predicate<NBTTagCompound>> nbtMatchers;
        Predicate<ItemStack> finalTest;
        Predicate<Integer> count;
        Predicate<ItemStack> test;
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            this.logger.log(Level.ERROR, "Unknown item '" + name + "'!");
            return null;
        }
        if (obj.has("empty")) {
            boolean empty = obj.get("empty").getAsBoolean();
            return s -> s.func_190926_b() == empty;
        }
        if (obj.has("damage")) {
            Predicate<Integer> damage = this.getExpression(obj.get("damage"));
            if (damage == null) {
                return null;
            }
            test = s -> s.func_77973_b() == item && damage.test(s.func_77952_i());
        } else {
            test = s -> s.func_77973_b() == item;
        }
        if (obj.has("count") && (count = this.getExpression(obj.get("count"))) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && count.test(s.func_190916_E());
        }
        if (obj.has("ore")) {
            int oreId = OreDictionary.getOreID((String)obj.get("ore").getAsString());
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && this.isMatchingOreId(s.func_190926_b() ? EMPTYINTS : OreDictionary.getOreIDs((ItemStack)s), oreId);
        }
        if (obj.has("mod")) {
            String mod = obj.get("mod").getAsString();
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && "mod".equals(s.func_77973_b().getRegistryName().func_110624_b());
        }
        if (obj.has("nbt") && (nbtMatchers = this.getNbtMatchers(obj)) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && nbtMatchers.stream().allMatch(p -> p.test(s.func_77978_p()));
        }
        if (obj.has("energy") && (energy = this.getExpression(obj.get("energy"))) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && energy.test(this.getEnergy((ItemStack)s));
        }
        return test;
    }

    private int getEnergy(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage capability = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return capability.getEnergyStored();
        }
        return 0;
    }

    private boolean contains(World world, BlockPos pos, @Nullable EnumFacing side, @Nonnull List<Predicate<ItemStack>> matchers) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                for (Predicate<ItemStack> matcher : matchers) {
                    if (!matcher.test(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int getEnergy(World world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side);
            return energy.getEnergyStored();
        }
        return 0;
    }

    private List<Predicate<NBTTagCompound>> getNbtMatchers(JsonObject obj) {
        JsonArray nbtArray = obj.getAsJsonArray("nbt");
        return this.getNbtMatchers(nbtArray);
    }

    private List<Predicate<NBTTagCompound>> getNbtMatchers(JsonArray nbtArray) {
        ArrayList<Predicate<NBTTagCompound>> nbtMatchers = new ArrayList<Predicate<NBTTagCompound>>();
        for (JsonElement element : nbtArray) {
            JsonObject o = element.getAsJsonObject();
            String tag = o.get("tag").getAsString();
            if (o.has("contains")) {
                List<Predicate<NBTTagCompound>> subMatchers = this.getNbtMatchers(o.getAsJsonArray("contains"));
                nbtMatchers.add(tagCompound -> {
                    if (tagCompound != null) {
                        NBTTagList list = tagCompound.func_150295_c(tag, 10);
                        for (NBTBase base : list) {
                            for (Predicate matcher : subMatchers) {
                                if (!matcher.test((NBTTagCompound)base)) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                });
                continue;
            }
            Predicate<Integer> nbt = this.getExpression(o.get("value"));
            if (nbt == null) {
                return null;
            }
            nbtMatchers.add(tagCompound -> nbt.test(tagCompound.func_74762_e(tag)));
        }
        return nbtMatchers;
    }

    protected List<Predicate<ItemStack>> getItems(List<String> itemNames) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Predicate<ItemStack> matcher;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                matcher = this.getMatcher(name);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                matcher = this.getMatcher(obj);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            this.logger.log(Level.ERROR, "Item description '" + json + "' is not valid!");
        }
        return items;
    }

    public void addHelmetCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.HELMET));
        this.addArmorCheck(items, EntityEquipmentSlot.HEAD);
    }

    public void addChestplateCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.CHESTPLATE));
        this.addArmorCheck(items, EntityEquipmentSlot.CHEST);
    }

    public void addLeggingsCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.LEGGINGS));
        this.addArmorCheck(items, EntityEquipmentSlot.LEGS);
    }

    public void addBootsCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.BOOTS));
        this.addArmorCheck(items, EntityEquipmentSlot.FEET);
    }

    private void addArmorCheck(List<Predicate<ItemStack>> items, EntityEquipmentSlot slot) {
        this.checks.add((event, query) -> {
            ItemStack armorItem;
            EntityPlayer player = query.getPlayer(event);
            if (player != null && !(armorItem = player.func_184582_a(slot)).func_190926_b()) {
                for (Predicate item : items) {
                    if (!item.test(armorItem)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addHeldItemCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.HELDITEM));
        this.checks.add((event, query) -> {
            ItemStack mainhand;
            EntityPlayer player = query.getPlayer(event);
            if (player != null && !(mainhand = player.func_184614_ca()).func_190926_b()) {
                for (Predicate item : items) {
                    if (!item.test(mainhand)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addOffHandItemCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.OFFHANDITEM));
        this.checks.add((event, query) -> {
            ItemStack offhand;
            EntityPlayer player = query.getPlayer(event);
            if (player != null && !(offhand = player.func_184592_cb()).func_190926_b()) {
                for (Predicate item : items) {
                    if (!item.test(offhand)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addBothHandsItemCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(CommonRuleKeys.BOTHHANDSITEM));
        this.checks.add((event, query) -> {
            EntityPlayer player = query.getPlayer(event);
            if (player != null) {
                ItemStack mainhand;
                ItemStack offhand = player.func_184592_cb();
                if (!offhand.func_190926_b()) {
                    for (Predicate item : items) {
                        if (!item.test(offhand)) continue;
                        return true;
                    }
                }
                if (!(mainhand = player.func_184614_ca()).func_190926_b()) {
                    for (Predicate item : items) {
                        if (!item.test(mainhand)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    private void addStateCheck(AttributeMap map) {
        String value;
        String state;
        String s = map.get(CommonRuleKeys.STATE);
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "Bad state=value specifier '" + s + "'!");
            return;
        }
        this.checks.add((event, query) -> value.equals(this.compatibility.getState(query.getWorld(event), state)));
    }

    private void addPStateCheck(AttributeMap map) {
        String value;
        String state;
        String s = map.get(CommonRuleKeys.PSTATE);
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "Bad state=value specifier '" + s + "'!");
            return;
        }
        this.checks.add((event, query) -> value.equals(this.compatibility.getPlayerState(query.getPlayer(event), state)));
    }

    private void addSummerCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.SUMMER);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSummer(query.getWorld(event)));
    }

    private void addWinterCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.WINTER);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isWinter(query.getWorld(event)));
    }

    private void addSpringCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.SPRING);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSpring(query.getWorld(event)));
    }

    private void addAutumnCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.AUTUMN);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isAutumn(query.getWorld(event)));
    }

    private void addGameStageCheck(AttributeMap map) {
        String stage = map.get(CommonRuleKeys.GAMESTAGE);
        this.checks.add((event, query) -> this.compatibility.hasGameStage(query.getPlayer(event), stage));
    }

    private void addInCityCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INCITY).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isCity(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isCity(query, event));
        }
    }

    private void addInStreetCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INSTREET).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isStreet(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isStreet(query, event));
        }
    }

    private void addInSphereCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INSPHERE).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.inSphere(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.inSphere(query, event));
        }
    }

    private void addInBuildingCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INBUILDING).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isBuilding(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isBuilding(query, event));
        }
    }

    public void addBaubleCheck(AttributeMap map, Key<String> key, Supplier<int[]> slotSupplier) {
        List<Predicate<ItemStack>> items = this.getItems(map.getList(key));
        this.checks.add((event, query) -> {
            EntityPlayer player = query.getPlayer(event);
            if (player != null) {
                for (int slot : (int[])slotSupplier.get()) {
                    ItemStack stack = this.compatibility.getBaubleStack(player, slot);
                    if (stack.func_190926_b()) continue;
                    for (Predicate item : items) {
                        if (!item.test(stack)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }
}

