/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.wolfdire;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import teamroots.emberroot.config.ConfigManager;
import teamroots.emberroot.entity.wolfdire.EntityDireWolf;
import teamroots.emberroot.entity.wolfdire.ModelDireWolf;
import teamroots.emberroot.util.RenderUtil;

public class RenderDirewolf
extends RenderLiving<EntityDireWolf> {
    private int debugCounter = 0;

    public RenderDirewolf(RenderManager rm) {
        super(rm, (ModelBase)new ModelDireWolf(), 0.5f);
    }

    protected float handleRotationFloat(EntityDireWolf wolf, float partialTick) {
        return wolf.getTailRotation();
    }

    protected void preRenderCallback(EntityDireWolf entity, float partialTick) {
        if (this.debugCounter == 4) {
            this.field_77045_g = new ModelDireWolf();
            ++this.debugCounter;
        }
        float scale = 1.25f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.1f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(scale - 0.1f), (float)scale, (float)scale);
    }

    public void doRender(EntityDireWolf entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GL11.glPopMatrix();
        if (ConfigManager.renderDebugHitboxes) {
            RenderUtil.renderEntityBoundingBox((EntityLiving)entity, x, y, z);
        }
    }

    protected ResourceLocation getEntityTexture(EntityDireWolf entity) {
        String colour = entity.getVariantEnum().nameLower();
        return new ResourceLocation("emberroot", "textures/entity/wolf_" + colour + ".png");
    }

    public static class Factory
    implements IRenderFactory<EntityDireWolf> {
        public Render<? super EntityDireWolf> createRenderFor(RenderManager manager) {
            return new RenderDirewolf(manager);
        }
    }
}

